/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.core.block.BaseBlockEntity;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkLoaderBlockEntity
extends BaseBlockEntity {
    private final ChunkLoaderType type;
    public final int animationOffset = new Random().nextInt(20000);
    private UUID owner;

    public ChunkLoaderBlockEntity(BlockPos pos, BlockState state, ChunkLoaderType type) {
        super(type.getBlockEntityType(), pos, state);
        this.type = type;
    }

    public ChunkLoaderType getChunkLoaderType() {
        return this.type;
    }

    void setOwner(UUID owner) {
        if (!this.level.isClientSide && owner != null) {
            this.owner = owner;
            this.dataChanged();
            ChunkLoadingCapability.get(this.level).castServer().addChunkLoader(this);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void onLoad() {
        if (!this.level.isClientSide && this.owner != null) {
            ChunkLoadingCapability.get(this.level).castServer().addChunkLoader(this);
        }
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        if (this.owner != null) {
            compound.putUUID("owner", this.owner);
        }
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.owner = compound.contains("owner", 11) ? compound.getUUID("owner") : null;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide && this.level.getServer() != null) {
            BlockState state = this.getBlockState();
            this.level.getServer().doRunTask(new TickTask(1, () -> {
                LevelChunk chunk = this.level.getChunkSource().getChunkNow(SectionPos.blockToSectionCoord((int)this.worldPosition.getX()), SectionPos.blockToSectionCoord((int)this.worldPosition.getY()));
                if (chunk != null && !chunk.getBlockState(this.worldPosition).is(state.getBlock()) && !(chunk.getBlockEntity(this.worldPosition) instanceof ChunkLoaderBlockEntity) && this.hasOwner()) {
                    ChunkLoadingCapability.get(this.level).castServer().removeChunkLoader(this);
                }
            }));
        }
    }
}

