/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.shader.uniform;

import com.mojang.blaze3d.shaders.Uniform;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.client.renderer.ShaderInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderInstance.class})
public class ShaderInstanceMixin {
    @Shadow
    @Final
    private List<String> samplerNames;
    @Shadow
    @Final
    private int programId;
    @Unique
    private Object2IntMap<String> uniformCache;

    @Unique
    private void initCache() {
        this.uniformCache = new Object2IntOpenHashMap();
        this.uniformCache.defaultReturnValue(-1);
        for (String samplerName : this.samplerNames) {
            int location = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)samplerName);
            if (location == -1) {
                throw new IllegalStateException("Failed to find uniform '%s' during shader init".formatted(samplerName));
            }
            this.uniformCache.put((Object)samplerName, location);
        }
    }

    @Inject(method={"updateLocations"}, at={@At(value="RETURN")}, require=0)
    private void initCache(CallbackInfo ci) {
        this.initCache();
    }

    @Redirect(method={"apply"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/shaders/Uniform;glGetUniformLocation(ILjava/lang/CharSequence;)I"))
    private int redirectGetUniformLocation(int program, CharSequence name) {
        int location = this.uniformCache.getInt((Object)name);
        if (location == -1) {
            throw new IllegalStateException("Failed to find uniform '%s' during shader bind");
        }
        return location;
    }
}

