/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface SlotProvider {
    public static final SlotProvider ALL = inv -> IntStream.range(0, inv.items.size()).mapToObj(i -> Slot.invSlot(inv, i)).iterator();
    public static final SlotProvider OFF_HAND = inv -> IntStream.range(0, inv.offhand.size()).mapToObj(i -> Slot.offHandSlot(inv, i)).iterator();
    public static final SlotProvider MAIN_HAND = inv -> List.of(Slot.invSlot(inv, inv.selected)).iterator();

    public Iterator<Slot> getSlots(Inventory var1);

    public static SlotProvider hand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return MAIN_HAND;
        }
        return OFF_HAND;
    }

    public static SlotProvider single(int slot) {
        return inv -> List.of(Slot.invSlot(inv, slot)).iterator();
    }

    public static interface Slot {
        public ItemStack getStack();

        public boolean add(ItemStack var1, Inventory var2, Player var3);

        public static Slot invSlot(final Inventory inv, final int slot) {
            return new Slot(){

                @Override
                public ItemStack getStack() {
                    return inv.getItem(slot);
                }

                @Override
                public boolean add(ItemStack toAdd, Inventory inv2, Player player) {
                    ItemStack current = this.getStack();
                    if (!current.isEmpty() && !inv2.hasRemainingSpaceForItem(current, toAdd)) {
                        return false;
                    }
                    if (toAdd.isEmpty()) {
                        return false;
                    }
                    try {
                        int originalCount;
                        do {
                            originalCount = toAdd.getCount();
                            toAdd.setCount(inv2.addResource(slot, toAdd));
                        } while (!toAdd.isEmpty() && toAdd.getCount() < originalCount);
                        return toAdd.getCount() < originalCount;
                    }
                    catch (Throwable var6) {
                        CrashReport crashReport = CrashReport.forThrowable((Throwable)var6, (String)"Adding item to inventory");
                        CrashReportCategory crashReportCategory = crashReport.addCategory("Item being added");
                        crashReportCategory.setDetail("Item ID", (Object)Item.getId((Item)toAdd.getItem()));
                        crashReportCategory.setDetail("Item data", (Object)toAdd.getDamageValue());
                        crashReportCategory.setDetail("Item name", () -> toAdd.getHoverName().getString());
                        throw new ReportedException(crashReport);
                    }
                }
            };
        }

        public static Slot offHandSlot(final Inventory inv, final int offHandSlot) {
            return new Slot(){

                @Override
                public ItemStack getStack() {
                    return (ItemStack)inv.offhand.get(offHandSlot);
                }

                @Override
                public boolean add(ItemStack stack, Inventory inv2, Player player) {
                    if (stack.isEmpty()) {
                        return false;
                    }
                    try {
                        int originalCount;
                        do {
                            originalCount = stack.getCount();
                            this.addResourceOffHand(stack, inv2);
                        } while (!stack.isEmpty() && stack.getCount() < originalCount);
                        if (stack.getCount() == originalCount && player.getAbilities().instabuild) {
                            stack.setCount(0);
                            return true;
                        }
                        return stack.getCount() < originalCount;
                    }
                    catch (Throwable var6) {
                        CrashReport crashReport = CrashReport.forThrowable((Throwable)var6, (String)"Adding item to inventory");
                        CrashReportCategory crashReportCategory = crashReport.addCategory("Item being added");
                        crashReportCategory.setDetail("Item ID", (Object)Item.getId((Item)stack.getItem()));
                        crashReportCategory.setDetail("Item data", (Object)stack.getDamageValue());
                        crashReportCategory.setDetail("Item name", () -> stack.getHoverName().getString());
                        throw new ReportedException(crashReport);
                    }
                }

                private void addResourceOffHand(ItemStack toAdd, Inventory inv2) {
                    NonNullList offHand = inv2.offhand;
                    for (int offSlot = 0; offSlot < offHand.size(); ++offSlot) {
                        int stackCount = toAdd.getCount();
                        ItemStack itemStack = (ItemStack)offHand.get(offSlot);
                        if (itemStack.isEmpty()) {
                            itemStack = toAdd.copyWithCount(0);
                            offHand.set(offSlot, (Object)itemStack);
                            return;
                        }
                        int possibleSpace = inv2.getMaxStackSize(itemStack) - itemStack.getCount();
                        int addedCount = Math.min(stackCount, possibleSpace);
                        if (addedCount == 0) continue;
                        itemStack.grow(addedCount);
                        itemStack.setPopTime(5);
                        toAdd.setCount(stackCount -= addedCount);
                    }
                }
            };
        }
    }
}

