/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ClickableList
extends Button {
    private String[] headers;
    private boolean[] isCategory;
    @Nonnull
    private List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
    private float textScale;
    private final Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler;
    private int offset;
    private int maxOffset;
    private final int perPage;
    private ManualScreen gui;

    ClickableList(ManualScreen gui, int x, int y, int w, int h, float textScale, @Nonnull List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes, Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler) {
        super(x, y, w, h, (Component)Component.empty(), btn -> {}, DEFAULT_NARRATION);
        this.gui = gui;
        this.textScale = textScale;
        this.handler = handler;
        this.perPage = (h - 8) / this.getFontHeight();
        this.setEntries(nodes);
    }

    int getFontHeight() {
        Objects.requireNonNull(this.gui.manual.fontRenderer());
        return (int)(9.0f * this.textScale);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mx, int my, float partialTicks) {
        PoseStack transform = graphics.pose();
        if (!this.visible) {
            return;
        }
        Font fr = this.gui.manual.fontRenderer();
        int mmY = my - this.getY();
        transform.pushPose();
        transform.scale(this.textScale, this.textScale, this.textScale);
        transform.translate((float)this.getX() / this.textScale, (float)this.getY() / this.textScale, 0.0f);
        this.isHovered = mx >= this.getX() && mx < this.getX() + this.width && my >= this.getY() && my < this.getY() + this.height;
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            int j;
            boolean currEntryHovered;
            int col = this.gui.manual.getTextColour();
            boolean bl = currEntryHovered = this.isHovered && mmY >= i * this.getFontHeight() && mmY < (i + 1) * this.getFontHeight();
            if (currEntryHovered) {
                col = this.gui.manual.getHighlightColour();
            }
            if (i != 0) {
                transform.translate(0.0f, (float)this.getFontHeight(), 0.0f);
            }
            if ((j = this.offset + i) > this.headers.length - 1) {
                j = this.headers.length - 1;
            }
            String s = this.headers[j];
            if (this.isCategory[j]) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                graphics.blit(this.gui.texture, 0, 0, 11, 226 + (currEntryHovered ? 20 : 0), 5, 10);
            }
            graphics.drawString(fr, s, this.isCategory[j] ? 7 : 0, 0, col, false);
        }
        transform.scale(1.0f / this.textScale, 1.0f / this.textScale, 1.0f / this.textScale);
        transform.popPose();
        if (this.maxOffset > 0) {
            int minVisibleBlack = 0x1B000000;
            int mainBarBlack = 0x28000000;
            float totalHeight = this.maxOffset * this.getFontHeight() + this.height;
            float heightTopRel = (float)(this.offset * this.getFontHeight()) / totalHeight;
            float heightBottomRel = (float)(this.offset * this.getFontHeight() + this.height) / totalHeight;
            int heightTopAbs = (int)(heightTopRel * (float)this.height);
            int heightBottomAbs = (int)(heightBottomRel * (float)this.height);
            graphics.fill(this.getX() + this.width, this.getY(), this.getX() + this.width + 8, this.getY() + this.height, 0x1B000000);
            graphics.fill(this.getX() + this.width + 1, this.getY() + heightTopAbs, this.getX() + this.width + 7, this.getY() + heightBottomAbs, 0x28000000);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0 && this.offset < this.maxOffset) {
            ++this.offset;
            return true;
        }
        if (scrollY > 0.0 && this.offset > 0) {
            --this.offset;
            return true;
        }
        return false;
    }

    @Nullable
    public Tree.AbstractNode<ResourceLocation, ManualEntry> getSelected(double mx, double my) {
        if (!super.clicked(mx, my)) {
            return null;
        }
        double mmY = my - (double)this.getY();
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            if (!(mmY >= (double)(i * this.getFontHeight())) || !(mmY < (double)((i + 1) * this.getFontHeight()))) continue;
            return this.nodes.get(this.offset + i);
        }
        return null;
    }

    public void onClick(double mx, double my) {
        this.handler.accept(this.getSelected(mx, my));
    }

    protected boolean clicked(double mx, double my) {
        return this.getSelected(mx, my) != null;
    }

    public void setEntries(List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes) {
        this.nodes = nodes;
        this.headers = new String[nodes.size()];
        this.isCategory = new boolean[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.headers[i] = ManualUtils.getTitleForNode(nodes.get(i), this.gui.manual);
            this.isCategory[i] = !nodes.get(i).isLeaf();
        }
        this.maxOffset = this.perPage < this.headers.length ? this.headers.length - this.perPage : 0;
        this.height = this.getFontHeight() * Math.min(this.perPage, this.headers.length);
    }

    public int getHeight() {
        return this.height;
    }
}

