/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;

public class IEItemFluidHandler
extends FluidHandlerItemStack {
    public static Component fluidItemInfoFlavor(@Nullable FluidStack fluid, int fluidCapacity) {
        if (fluid != null && fluid.getAmount() > 0) {
            FluidType attr = fluid.getFluid().getFluidType();
            ChatFormatting rarity = attr.getRarity() == Rarity.COMMON ? ChatFormatting.GRAY : attr.getRarity().color();
            return TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.fluidStack", (Object[])new Object[]{fluid.getHoverName(), fluid.getAmount(), fluidCapacity}), rarity);
        }
        return TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drill.empty"), ChatFormatting.GRAY);
    }

    public IEItemFluidHandler(ItemStack container, int capacity) {
        super(IEDataComponents.GENERIC_FLUID, container, capacity);
    }

    public int getCapacity() {
        if (this.container.getItem() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.getItem()).getCapacity(this.container, this.capacity);
        }
        return this.capacity;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (this.container.getItem() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.getItem()).allowFluid(this.container, fluid);
        }
        return true;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack fluid) {
        FluidStack tankFluid = this.getFluidInTank(tank);
        return tankFluid.isEmpty() && this.canFillFluidType(fluid) || FluidStack.isSameFluidSameComponents((FluidStack)tankFluid, (FluidStack)fluid);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.container.getCount() != 1 || resource.isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getCapacity(), resource.getAmount());
            if (doFill.execute()) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (FluidStack.isSameFluid((FluidStack)contained, (FluidStack)resource)) {
            int fillAmount = Math.min(this.getCapacity() - contained.getAmount(), resource.getAmount());
            if (doFill.execute() && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }
}

