/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.IFluidAwareRecipe;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public abstract class AbstractShapedRecipe<MatchLocation extends AbstractFluidAwareRecipe.IMatchLocation>
extends ShapedRecipe
implements IFluidAwareRecipe<MatchLocation> {
    private final int recipeWidth;
    private final int recipeHeight;
    private final CraftingBookCategory category;

    public AbstractShapedRecipe(ShapedRecipe vanilla) {
        this(vanilla.getGroup(), vanilla.getWidth(), vanilla.getHeight(), vanilla.getResultItem(null), vanilla.category(), vanilla.pattern);
    }

    public AbstractShapedRecipe(String groupIn, int recipeWidth, int recipeHeight, ItemStack recipeOutput, CraftingBookCategory category, ShapedRecipePattern pattern) {
        super(groupIn, category, pattern, recipeOutput);
        this.recipeWidth = recipeWidth;
        this.recipeHeight = recipeHeight;
        this.category = category;
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.IE_SHAPED_SERIALIZER.get();
    }

    public ShapedRecipe toVanilla() {
        return new ShapedRecipe(this.getGroup(), this.category, this.pattern, this.getResultItem(null));
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public boolean isIncomplete() {
        NonNullList nonnulllist = this.getIngredients();
        if (nonnulllist.isEmpty()) {
            return true;
        }
        return nonnulllist.stream().filter(ingredient -> !ingredient.isEmpty()).anyMatch(Ingredient::hasNoItems);
    }
}

