/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import com.google.common.collect.ImmutableList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeskBlock<T extends BlockEntity>
extends IEEntityBlock<T> {
    private static final CachedShapesWithTransform<Boolean, Direction> SHAPES = CachedShapesWithTransform.createDirectional(b -> {
        double xMin = b != false ? 0.0 : 0.0625;
        double xMax = xMin + 0.9375;
        return ImmutableList.of((Object)new AABB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0), (Object)new AABB(xMin, 0.0, 0.0625, xMax, 0.8125, 0.9375));
    });
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.WOOD).strength(2.0f, 5.0f).noOcclusion();
    public static final Property<Direction> FACING = IEProperties.FACING_HORIZONTAL;
    public static final Property<Boolean> DUMMY = IEProperties.MULTIBLOCKSLAVE;

    public DeskBlock(Supplier<BlockEntityType<T>> tileType, BlockBehaviour.Properties props) {
        super(tileType, props);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DUMMY, FACING, BlockStateProperties.WATERLOGGED});
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        Direction newFacing = rot.rotate((Direction)state.getValue(FACING));
        return (BlockState)state.setValue(FACING, (Comparable)newFacing);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (mirrorIn == Mirror.NONE) {
            return state;
        }
        Direction oldFacing = (Direction)state.getValue(FACING);
        Direction newFacing = mirrorIn.mirror(oldFacing);
        boolean oldDummy = (Boolean)state.getValue(DUMMY);
        boolean newDummy = !oldDummy;
        return (BlockState)((BlockState)state.setValue(FACING, (Comparable)newFacing)).setValue(DUMMY, (Comparable)Boolean.valueOf(newDummy));
    }

    @Override
    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        BlockPos start = context.getClickedPos();
        Direction tableFacing = PlacementLimitation.HORIZONTAL.getDirectionForPlacement(context);
        Direction dummyDir = DeskBlock.getDeskDummyOffset(context.getLevel(), context.getClickedPos(), tableFacing, context);
        return DeskBlock.areAllReplaceable(start, start.relative(dummyDir), context);
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction updateSide, BlockState updatedState, LevelAccessor worldIn, BlockPos currentPos, BlockPos updatedPos) {
        Direction facing = (Direction)stateIn.getValue(FACING);
        boolean dummy = (Boolean)stateIn.getValue(DUMMY);
        BlockPos otherHalf = currentPos.relative(facing.getClockWise(), dummy ? -1 : 1);
        BlockState otherState = worldIn.getBlockState(otherHalf);
        if (otherState.getBlock() == this && otherState.getValue(FACING) == facing && (Boolean)otherState.getValue(DUMMY) == !dummy) {
            return stateIn;
        }
        for (Direction candidate : FACING.getPossibleValues()) {
            BlockPos otherHalf2;
            BlockState otherState2;
            if (candidate == facing || (otherState2 = worldIn.getBlockState(otherHalf2 = currentPos.relative(candidate.getClockWise(), dummy ? -1 : 1))).getBlock() != this || otherState2.getValue(FACING) != candidate || (Boolean)otherState2.getValue(DUMMY) != !dummy) continue;
            return (BlockState)stateIn.setValue(FACING, (Comparable)candidate);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static Direction getDeskDummyOffset(Level world, BlockPos pos, Direction facing, BlockPlaceContext ctx) {
        Direction dummyDir = facing.getAxis() == Direction.Axis.X ? (ctx.getClickLocation().z < 0.5 ? Direction.NORTH : Direction.SOUTH) : (ctx.getClickLocation().x < 0.5 ? Direction.WEST : Direction.EAST);
        BlockPos dummyPos = pos.relative(dummyDir);
        if (!world.getBlockState(dummyPos).canBeReplaced(BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)dummyPos, (Direction)dummyDir))) {
            dummyDir = dummyDir.getOpposite();
        }
        return dummyDir;
    }

    public static void placeDummies(BlockState state, Level world, BlockPos pos, BlockPlaceContext ctx) {
        boolean mirror;
        Direction facing = (Direction)state.getValue(FACING);
        Direction dummyDir = DeskBlock.getDeskDummyOffset(world, pos, facing, ctx);
        BlockPos dummyPos = pos.relative(dummyDir);
        boolean bl = mirror = dummyDir != facing.getClockWise();
        if (mirror) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(DUMMY, (Comparable)Boolean.valueOf(true)));
        }
        world.setBlockAndUpdate(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(!mirror)), world, pos));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Boolean)state.getValue(DUMMY), (Direction)state.getValue(FACING));
    }
}

