/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BreakerSwitchBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IAdvancedDirectionalBE,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IStateBasedDirectional {
    public static final int LEFT_INDEX = 0;
    public static final int RIGHT_INDEX = 1;
    public int rotation = 0;
    public int wires = 0;
    public boolean inverted = false;
    private static final CachedVoxelShapes<Pair<Direction, Integer>> SHAPES = new CachedVoxelShapes<Pair>(pair -> {
        Vec3 start = new Vec3(0.25, 0.1875, 0.0);
        Vec3 end = new Vec3(0.75, 0.8125, 0.5);
        Matrix4 mat = new Matrix4((Direction)pair.getFirst());
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)((Integer)pair.getSecond()).intValue(), 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        start = mat.apply(start);
        end = mat.apply(end);
        return ImmutableList.of((Object)new AABB(start, end));
    });

    public BreakerSwitchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends BreakerSwitchBlockEntity>)((BlockEntityType)IEBlockEntities.BREAKER_SWITCH.get()), pos, state);
    }

    public BreakerSwitchBlockEntity(BlockEntityType<? extends BreakerSwitchBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        Matrix4 mat = new Matrix4().setIdentity().translate(0.5, 0.5, 0.0).rotate(-1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0).multiply(Matrix4.inverseFacing(this.getFacing()));
        Vec3 transformedHit = mat.apply(new Vec3((double)info.hitX, (double)info.hitY, (double)info.hitZ));
        return new ConnectionPoint(this.worldPosition, transformedHit.x > 0.5 ? 1 : 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if ("HV".equals(cableType.getCategory()) && !this.canTakeHV()) {
            return false;
        }
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            for (Connection c : this.globalNet.getLocalNet(cp).getConnections(cp)) {
                if (c.isInternal() || !cp.equals(target) && cableType.getCategory().equals(c.type.getCategory())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean canTakeHV() {
        return false;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        ++this.wires;
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        WireType type;
        WireType wireType = type = connection != null ? connection.type : null;
        this.wires = type == null ? 0 : --this.wires;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        nbt.putInt("rotation", this.rotation);
        nbt.putInt("wires", this.wires);
        nbt.putBoolean("inverted", this.inverted);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        this.rotation = nbt.getInt("rotation");
        this.wires = nbt.getInt("wires");
        this.inverted = nbt.getBoolean("inverted");
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Matrix4 mat = new Matrix4(this.getFacing());
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        boolean isLeft = here.index() == 0;
        return mat.apply(new Vec3(isLeft ? 0.25 : 0.75, 0.5, 0.125));
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        this.rotation = (this.rotation + 3) % 4;
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            for (Connection c : this.getLocalNet(cp.index()).getConnections(cp)) {
                if (c.isInternal()) continue;
                this.globalNet.updateCatenaryData(c);
            }
        }
        this.setChanged();
        this.markContainingBlockForUpdate(this.getBlockState());
        return true;
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        boolean oldPassing = this.allowEnergyToPass();
        boolean bl = this.inverted = !this.inverted;
        if (!this.level.isClientSide) {
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsSignal." + (this.inverted ? "invertedOn" : "invertedOff"))), true);
            this.notifyNeighbours();
            if (oldPassing != this.allowEnergyToPass()) {
                this.updateConductivity();
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!Utils.isHammer(heldItem)) {
            boolean active = !this.getIsActive();
            this.setActive(active);
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)IESounds.direSwitch.value(), SoundSource.BLOCKS, 2.5f, 1.0f);
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), active ? 1 : 0, 0);
            this.notifyNeighbours();
            this.updateConductivity();
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void updateConductivity() {
        if (this.allowEnergyToPass()) {
            this.globalNet.addConnection(new Connection(this.worldPosition, 0, 1));
        } else {
            this.globalNet.removeConnection(new Connection(this.worldPosition, 0, 1));
        }
    }

    public void notifyNeighbours() {
        this.setChanged();
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        for (Direction f : DirectionUtils.VALUES) {
            this.level.updateNeighborsAt(this.getBlockPos().relative(f), this.getBlockState().getBlock());
        }
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (super.triggerEvent(id, arg)) {
            return true;
        }
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get((Pair<Direction, Integer>)Pair.of((Object)this.getFacing(), (Object)this.rotation));
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        return this.getIsActive() ^ this.inverted ? 15 : 0;
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        return side.getOpposite() == this.getFacing() && this.getIsActive() ^ this.inverted ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return true;
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        Direction f = Direction.SOUTH;
        int rotationSign = -1;
        if (side.getAxis() == Direction.Axis.Y) {
            float xFromMid = hitX - 0.5f;
            float zFromMid = hitZ - 0.5f;
            float max = Math.max(Math.abs(xFromMid), Math.abs(zFromMid));
            if (max == Math.abs(xFromMid)) {
                f = xFromMid < 0.0f ? Direction.WEST : Direction.EAST;
            } else {
                Direction direction = f = zFromMid < 0.0f ? Direction.NORTH : Direction.SOUTH;
            }
            if (side == Direction.DOWN) {
                f = f.getOpposite();
                rotationSign = 1;
            }
        }
        this.rotation = Direction.NORTH.get2DDataValue() + rotationSign * f.get2DDataValue();
        this.rotation = (this.rotation + 4) % 4;
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.worldPosition, 0), (Object)new ConnectionPoint(this.worldPosition, 1));
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        if (this.allowEnergyToPass()) {
            return ImmutableList.of((Object)new Connection(this.worldPosition, 0, 1));
        }
        return ImmutableList.of();
    }

    protected boolean allowEnergyToPass() {
        return this.getIsActive();
    }
}

