/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class IEShaderLayerCompositeTexture
extends AbstractTexture {
    private final ResourceLocation canvasTexture;
    private final ShaderLayer[] layers;

    public IEShaderLayerCompositeTexture(ResourceLocation canvasTexture, ShaderLayer[] layers) {
        this.canvasTexture = canvasTexture;
        this.layers = layers;
    }

    public void load(@Nonnull ResourceManager resourceManager) {
        this.releaseId();
        Resource iresource = (Resource)resourceManager.getResource(this.canvasTexture).orElseThrow();
        try (InputStream imageStream = iresource.open();
             NativeImage originalImage = NativeImage.read((InputStream)imageStream);){
            int canvasWidth = originalImage.getWidth();
            int canvasHeight = originalImage.getHeight();
            NativeImage finalTexture = new NativeImage(canvasWidth, canvasHeight, true);
            for (int layer = 0; layer < 17 && layer < this.layers.length; ++layer) {
                Object texPath = this.layers[layer].getTexture().getPath();
                if (!((String)texPath).startsWith("textures/")) {
                    texPath = "textures/" + (String)texPath;
                }
                if (!((String)texPath).endsWith(".png")) {
                    texPath = (String)texPath + ".png";
                }
                String texture = this.layers[layer].getTexture().getNamespace() + ":" + (String)texPath;
                Color4 colour = this.layers[layer].getColor();
                Resource iresource1 = (Resource)resourceManager.getResource(ResourceLocation.parse((String)texture)).orElseThrow();
                try (InputStream texStream = iresource1.open();
                     NativeImage texureImage = NativeImage.read((InputStream)texStream);){
                    float[] layerABGR = new float[]{colour.a(), colour.b(), colour.g(), colour.r()};
                    if ((double)layerABGR[0] < 0.2) {
                        layerABGR[0] = layerABGR[0] * 2.5f;
                    }
                    IntFunction<Integer> uInterpolate = uIn -> uIn;
                    IntFunction<Integer> vInterpolate = vIn -> vIn;
                    int bufImg2Size = Math.min(texureImage.getWidth(), texureImage.getHeight());
                    int uMin = 0;
                    int vMin = 0;
                    int uMax = canvasWidth;
                    int vMax = canvasHeight;
                    double[] texBounds = this.layers[layer].getTextureBounds();
                    if (texBounds != null) {
                        double uOffset = texBounds[0] * (double)canvasWidth;
                        double vOffset = texBounds[1] * (double)canvasHeight;
                        double uScale = (double)bufImg2Size / ((texBounds[2] - texBounds[0]) * (double)canvasWidth);
                        double vScale = (double)bufImg2Size / ((texBounds[3] - texBounds[1]) * (double)canvasHeight);
                        uInterpolate = uIn -> (int)Math.round(((double)uIn - uOffset) * uScale);
                        vInterpolate = vIn -> (int)Math.round(((double)vIn - vOffset) * vScale);
                        uMin = (int)uOffset;
                        vMin = (int)vOffset;
                        uMax = (int)(texBounds[2] * (double)canvasWidth);
                        vMax = (int)(texBounds[3] * (double)canvasHeight);
                    }
                    try {
                        for (int v = vMin; v < vMax; ++v) {
                            for (int u = uMin; u < uMax; ++u) {
                                int interV;
                                int interU = uInterpolate.apply(u) % bufImg2Size;
                                ColorABGR baseABGR = new ColorABGR(texureImage.getPixelRGBA(interU, interV = vInterpolate.apply(v) % bufImg2Size));
                                if (baseABGR.isTransparent()) continue;
                                int iNoise = originalImage.getPixelRGBA(u, v);
                                float[] noiseABGR = new float[]{(float)(iNoise & 0xFF) / 255.0f, (float)(iNoise >> 8 & 0xFF) / 255.0f, (float)(iNoise >> 16 & 0xFF) / 255.0f, (float)(iNoise >> 24 & 0xFF) / 255.0f};
                                baseABGR.modify(layerABGR);
                                baseABGR.modify(noiseABGR);
                                finalTexture.blendPixel(u, v, ColorABGR.blend(baseABGR, new ColorABGR(finalTexture.getPixelRGBA(u, v))).toInt());
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
            }
            TextureUtil.prepareImage((int)this.getId(), (int)0, (int)finalTexture.getWidth(), (int)finalTexture.getHeight());
            finalTexture.upload(0, 0, 0, 0, 0, finalTexture.getWidth(), finalTexture.getHeight(), false, false, false, false);
        }
        catch (IOException ioexception) {
            IELogger.error("Couldn't load layered image", ioexception);
        }
    }

    private static final class ColorABGR {
        private float a;
        private float b;
        private float g;
        private float r;

        private ColorABGR(float a, float b, float g, float r) {
            this.a = Math.clamp(a, 0.0f, 1.0f);
            this.b = Math.clamp(b, 0.0f, 1.0f);
            this.g = Math.clamp(g, 0.0f, 1.0f);
            this.r = Math.clamp(r, 0.0f, 1.0f);
        }

        public ColorABGR(int abgr) {
            this((float)(abgr >> 24 & 0xFF) / 255.0f, (float)(abgr >> 16 & 0xFF) / 255.0f, (float)(abgr >> 8 & 0xFF) / 255.0f, (float)(abgr & 0xFF) / 255.0f);
        }

        public static ColorABGR blend(ColorABGR input, ColorABGR existing) {
            float mixFactor = 1.0f - input.a;
            float newAlpha = input.a * input.a + existing.a * mixFactor;
            if (existing.a == 0.0f) {
                newAlpha = input.a;
            } else if (newAlpha < existing.a) {
                newAlpha = existing.a;
            }
            return new ColorABGR(newAlpha, input.b * input.a + existing.b * mixFactor, input.g * input.a + existing.g * mixFactor, input.r * input.a + existing.r * mixFactor);
        }

        public boolean isTransparent() {
            return this.a == 0.0f || this.r == 0.0f && this.g == 0.0f && this.b == 0.0f;
        }

        public void modify(float[] rgba) {
            this.a *= rgba[0];
            this.b *= rgba[1];
            this.g *= rgba[2];
            this.r *= rgba[3];
        }

        public int toInt() {
            return (int)(this.a * 255.0f) << 24 | (int)(this.b * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.r * 255.0f);
        }
    }
}

