/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.index;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pyzpre.createbitterballen.CreateBitterballen;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class FluidRegistry {
    public static final FluidEntry<BaseFlowingFluid.Flowing> FRYING_OIL = CreateBitterballen.REGISTRATE.standardFluid("frying_oil", TransparentRenderedPlaceableFluidType.create(15582339, () -> Float.valueOf(0.125f))).lang("Frying Oil").properties(b -> b.viscosity(1500).density(500)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(5).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> KETCHUP = CreateBitterballen.REGISTRATE.standardFluid("ketchup", SolidRenderedPlaceableFluidType.create(10165277, () -> Float.valueOf(0.125f))).lang("Ketchup").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MAYONNAISE = CreateBitterballen.REGISTRATE.standardFluid("mayonnaise", SolidRenderedPlaceableFluidType.create(0xC9C79C, () -> Float.valueOf(0.125f))).lang("Mayonnaise").properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> CURDLED_MILK = CreateBitterballen.REGISTRATE.standardFluid("curdled_milk", SolidRenderedPlaceableFluidType.create(0xC9C79C, () -> Float.valueOf(0.125f))).lang("Curdled Milk").properties(b -> b.viscosity(1500).density(900)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<VirtualFluid> STAMPPOT = CreateBitterballen.REGISTRATE.virtualFluid("stamppot").lang("Stamppot").register();

    public static void register() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((BaseFlowingFluid.Flowing)FRYING_OIL.get()).getFluidType(), fluidState -> {
            if (fluidState.isSource()) {
                return Blocks.OBSIDIAN.defaultBlockState();
            }
            return ((TransparentBlock)BlockRegistry.CRYSTALLISED_OIL.get()).defaultBlockState();
        }));
    }

    private static class TransparentRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                TransparentRenderedPlaceableFluidType fluidType = new TransparentRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, true).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private TransparentRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return -855638017;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    private static class SolidRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }
}

