/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.events;

import com.pyzpre.createbitterballen.block.sunflower.SunflowerStem;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class SunflowerInteractionHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().getBlockState(pos);
        Player player = event.getEntity();
        Level world = event.getLevel();
        if (state.getBlock() == Blocks.SUNFLOWER) {
            boolean isUpperPart;
            SunflowerInteractionHandler.dropSunflowerHead(world, pos, player);
            boolean bl = isUpperPart = state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER;
            if (isUpperPart) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 18);
                pos = pos.below();
            }
            if (!isUpperPart) {
                BlockPos upperPartPos = pos.above();
                world.setBlock(upperPartPos, Blocks.AIR.defaultBlockState(), 18);
            }
            world.setBlock(pos, (BlockState)((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).defaultBlockState().setValue((Property)SunflowerStem.AGE, (Comparable)Integer.valueOf(2)), 3);
            world.setBlock(pos.above(), (BlockState)((BlockState)((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).defaultBlockState().setValue((Property)SunflowerStem.HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)SunflowerStem.AGE, (Comparable)Integer.valueOf(2)), 3);
            world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SunflowerInteractionHandler.grantAdvancementCriterion(serverPlayer, "create_bic_bit:lawn_defender", "harvested_sunflower");
            }
            event.setCanceled(true);
        }
    }

    private static void grantAdvancementCriterion(ServerPlayer player, String advancementID, String criterionKey) {
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        ResourceLocation id = ResourceLocation.parse((String)advancementID);
        Optional<AdvancementHolder> optionalHolder = Optional.ofNullable(player.server.getAdvancements().get(id));
        optionalHolder.ifPresent(holder -> {
            AdvancementProgress progress;
            if (holder.value().criteria().containsKey(criterionKey) && !(progress = playerAdvancements.getOrStartProgress(holder)).isDone()) {
                playerAdvancements.award(holder, criterionKey);
            }
        });
    }

    private static void dropSunflowerHead(Level world, BlockPos pos, Player player) {
        ItemStack sunflowerHead = new ItemStack((ItemLike)Items.SUNFLOWER);
        Block.popResource((Level)world, (BlockPos)pos, (ItemStack)sunflowerHead);
    }
}

