/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.effect;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class UnanchoredEffect
extends MobEffect {
    private static final Random RANDOM = new Random();
    private static final int MIN_COOLDOWN = 80;
    private int cooldown = 80;

    public UnanchoredEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide && --this.cooldown <= 0 && RANDOM.nextInt(100) < 20) {
            for (int i = 0; i < 10; ++i) {
                double dX = entity.getX() + (RANDOM.nextDouble() - 0.5) * 2.0 * 20.0;
                double dZ = entity.getZ() + (RANDOM.nextDouble() - 0.5) * 2.0 * 20.0;
                double dY = entity.getY() + (double)RANDOM.nextInt(7) - 3.0;
                if (!this.isTeleportDestinationSafe(entity, dX, dY, dZ)) continue;
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                BlockPos newPos = new BlockPos((int)dX, (int)dY, (int)dZ);
                this.spawnParticles(entity.level(), newPos);
                entity.teleportTo(dX, dY, dZ);
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.spawnParticles(entity.level(), newPos);
                this.cooldown = 80;
                break;
            }
        }
        return true;
    }

    private void spawnParticles(Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            for (int i = 0; i < 20; ++i) {
                double d0 = serverWorld.random.nextGaussian() * 0.02;
                double d1 = serverWorld.random.nextGaussian() * 0.02;
                double d2 = serverWorld.random.nextGaussian() * 0.02;
                double x = (double)pos.getX() + 0.5 + serverWorld.random.nextGaussian() * 0.5;
                double y = (double)pos.getY() + 0.6;
                double z = (double)pos.getZ() + 0.5 + serverWorld.random.nextGaussian() * 0.5;
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 1, d0, d1, d2, 0.0);
            }
        }
    }

    public boolean shouldApplyEffectTickThisTick(int tickCount, int amplifier) {
        return true;
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
    }

    private boolean isTeleportDestinationSafe(LivingEntity entity, double x, double y, double z) {
        BlockPos destinationPos = new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        BlockPos belowDestinationPos = destinationPos.below();
        BlockPos aboveDestinationPos = destinationPos.above();
        Level world = entity.level();
        boolean isDestinationBlockSafe = world.getBlockState(destinationPos).isAir() && world.getBlockState(aboveDestinationPos).isAir();
        boolean isBelowDestinationSolid = world.getBlockState(belowDestinationPos).canOcclude();
        return isDestinationBlockSafe && isBelowDestinationSolid;
    }
}

