/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.part;

import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.definition.ArsEngConfig;
import gripe._90.arseng.me.key.SourceKeyType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class SourceP2PTunnelPart
extends CapabilityP2PTunnelPart<SourceP2PTunnelPart, ISourceCap> {
    private static final P2PModels MODELS = new P2PModels(ArsEnergistique.makeId("part/source_p2p_tunnel"));
    private static final EmptyHandler EMPTY_HANDLER = new EmptyHandler();

    public SourceP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, CapabilityRegistry.SOURCE_CAPABILITY);
        this.inputHandler = new InputHandler();
        this.outputHandler = new OutputHandler();
        this.emptyHandler = EMPTY_HANDLER;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private OutputHandler getOutputHandler() {
        return (OutputHandler)this.outputHandler;
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putInt("source", this.getOutputHandler().bufferSource);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.getOutputHandler().bufferSource = data.getInt("source");
    }

    private class InputHandler
    implements ISourceCap {
        private InputHandler() {
        }

        public int getMaxReceive() {
            return this.getSourceCapacity();
        }

        public int getMaxExtract() {
            return 0;
        }

        public boolean canAcceptSource(int source) {
            for (SourceP2PTunnelPart output : SourceP2PTunnelPart.this.getOutputs()) {
                if (!output.getOutputHandler().canAcceptLocalSource(source)) continue;
                return true;
            }
            return false;
        }

        public boolean canProvideSource(int source) {
            return false;
        }

        public int getSource() {
            return SourceP2PTunnelPart.this.getOutputStream().map(part -> part.getOutputHandler().getLocalSource()).reduce(0, Integer::sum);
        }

        public int getSourceCapacity() {
            return SourceP2PTunnelPart.this.getOutputStream().map(part -> part.getOutputHandler().getLocalMaxSource()).reduce(0, Integer::sum);
        }

        public void setMaxSource(int max) {
            throw new UnsupportedOperationException();
        }

        public void setSource(int source) {
            throw new UnsupportedOperationException();
        }

        public int receiveSource(int source, boolean simulate) {
            List<SourceP2PTunnelPart> outputs = SourceP2PTunnelPart.this.getOutputStream().filter(part -> part.getOutputHandler().canAcceptLocalSource(source)).toList();
            if (outputs.isEmpty()) {
                return 0;
            }
            if (!simulate) {
                SourceP2PTunnelPart.this.deductTransportCost(source, SourceKeyType.TYPE);
            }
            int forEach = source / outputs.size();
            AtomicInteger spill = new AtomicInteger(source % outputs.size());
            AtomicInteger total = new AtomicInteger(0);
            outputs.forEach(output -> total.addAndGet(output.getOutputHandler().addSourceRespectingBuffer(forEach + (spill.getAndDecrement() > 0 ? 1 : 0), simulate)));
            return total.get();
        }

        public int extractSource(int source, boolean simulate) {
            return 0;
        }
    }

    private class OutputHandler
    implements ISourceCap {
        private static final int MAX_BUFFER = (Integer)ArsEngConfig.OUTPUT_P2P_BUFFER.get();
        private int bufferSource = 0;

        private OutputHandler() {
        }

        private boolean canAcceptLocalSource(int source) {
            return this.getLocalSource() + source < this.getLocalMaxSource();
        }

        private int addSourceRespectingBuffer(int amount, boolean simulate) {
            int source = 0;
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = SourceP2PTunnelPart.this.getAdjacentCapability();){
                ISourceCap tile = (ISourceCap)guard.get();
                if (tile != null && !(tile instanceof EmptyHandler)) {
                    source += tile.receiveSource(amount, simulate);
                    amount = 0;
                }
            }
            this.bufferSource += amount;
            if (this.bufferSource > MAX_BUFFER) {
                this.bufferSource = MAX_BUFFER;
            }
            return source += this.bufferSource;
        }

        private int getLocalSource() {
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = SourceP2PTunnelPart.this.getAdjacentCapability();){
                int n = this.bufferSource + ((ISourceCap)guard.get()).getSource();
                return n;
            }
        }

        private int getLocalMaxSource() {
            try (CapabilityP2PTunnelPart.CapabilityGuard guard = SourceP2PTunnelPart.this.getAdjacentCapability();){
                int n = MAX_BUFFER + ((ISourceCap)guard.get()).getSourceCapacity();
                return n;
            }
        }

        public int getMaxExtract() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                ISourceCap tile = (ISourceCap)input.get();
                int n = tile != SourceP2PTunnelPart.this.emptyHandler ? tile.getMaxExtract() : MAX_BUFFER;
                return n;
            }
        }

        public int getMaxReceive() {
            return 0;
        }

        public boolean canProvideSource(int source) {
            return this.extractSource(source, true) > 0;
        }

        public boolean canAcceptSource(int source) {
            return false;
        }

        public int getSource() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                int n = ((ISourceCap)input.get()).getSource() + this.bufferSource;
                return n;
            }
        }

        public int getSourceCapacity() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                int n = ((ISourceCap)input.get()).getSourceCapacity() + MAX_BUFFER;
                return n;
            }
        }

        public void setMaxSource(int max) {
            throw new UnsupportedOperationException();
        }

        public void setSource(int source) {
            throw new UnsupportedOperationException();
        }

        public int receiveSource(int source, boolean simulate) {
            return 0;
        }

        public int extractSource(int source, boolean simulate) {
            if (this.bufferSource >= source) {
                this.bufferSource -= source;
                return 0;
            }
            this.bufferSource = 0;
            try (CapabilityP2PTunnelPart.CapabilityGuard input = SourceP2PTunnelPart.this.getInputCapability();){
                int result = ((ISourceCap)input.get()).extractSource(source, simulate);
                if (!simulate) {
                    SourceP2PTunnelPart.this.deductTransportCost(result, SourceKeyType.TYPE);
                }
                int n = result;
                return n;
            }
        }
    }

    private static class EmptyHandler
    implements ISourceCap {
        private EmptyHandler() {
        }

        public boolean canAcceptSource(int source) {
            return false;
        }

        public boolean canProvideSource(int source) {
            return false;
        }

        public int getMaxExtract() {
            return 0;
        }

        public int getMaxReceive() {
            return 0;
        }

        public int getSource() {
            return 0;
        }

        public int getSourceCapacity() {
            return 0;
        }

        public void setSource(int source) {
        }

        public void setMaxSource(int max) {
        }

        public int receiveSource(int source, boolean simulate) {
            return 0;
        }

        public int extractSource(int source, boolean simulate) {
            return 0;
        }
    }
}

