/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.ConfigItemList;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public class StorageBlacklist
extends ConfigItemList {
    public static final StorageBlacklist INSTANCE = new StorageBlacklist();

    @Override
    protected void innerInitialize() {
        ModCommonConfig.INSTANCE.onLoad(() -> ((List)ModCommonConfig.INSTANCE.DRAWERS.storage.storeBlacklist.get()).forEach(this::register));
    }

    public boolean isBlacklisted(ItemStack stack) {
        Item item = stack.getItem();
        boolean canStore = true;
        if (item instanceof ItemDrawers) {
            canStore = (Boolean)ModCommonConfig.INSTANCE.DRAWERS.filled.canStoreInDrawers.get();
        }
        if (!canStore) {
            CustomData blockData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (blockData != null || customData != null) {
                return true;
            }
        }
        return this.isListed(stack);
    }

    @Override
    protected void logRegisterNamespace(@NotNull String namespace) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
            ModServices.log.info("New denied storage namespace " + namespace);
        }
    }

    @Override
    protected void logRegisterItem(@NotNull ItemStack item) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
            ModServices.log.info("New denied storage item " + String.valueOf(item.getItem()));
        }
    }
}

