/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.config.StorageBlacklist;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.CompactingHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackTagMatcher;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FractionalDrawerGroup
extends BlockEntityDataShim
implements IDrawerGroup {
    private final FractionalStorage storage;
    private final FractionalDrawer[] slots;
    private final int[] order;

    public FractionalDrawerGroup(int slotCount) {
        this.storage = new FractionalStorage(this, slotCount);
        this.slots = new FractionalDrawer[slotCount];
        this.order = new int[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = new FractionalDrawer(this.storage, i);
            this.order[i] = i;
        }
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @NotNull
    public IFractionalDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED_FRACTIONAL;
        }
        return this.slots[slot];
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    public int getPooledCount() {
        return this.storage.getPooledCount();
    }

    public void setPooledCount(int count) {
        this.storage.setPooledCount(count);
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        if (tag.contains("Drawers")) {
            this.storage.deserializeNBT(provider, tag.getCompound("Drawers"));
        }
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
        tag.put("Drawers", (Tag)this.storage.serializeNBT(provider));
        return tag;
    }

    public void syncAttributes() {
        this.storage.syncAttributes();
    }

    protected Level getWorld() {
        return null;
    }

    protected void log(String message) {
    }

    protected int getStackCapacity() {
        return 0;
    }

    protected void onItemChanged() {
    }

    protected void onAmountChanged() {
    }

    private static class FractionalStorage {
        private final FractionalDrawerGroup group;
        private final int slotCount;
        private final ItemStack[] protoStack;
        private final int[] convRate;
        private final ItemStackMatcher[] matchers;
        private int pooledCount;
        private ItemStack cacheKey = ItemStack.EMPTY;
        private final ItemStack[] cachedProtoStack;
        private final int[] cachedConvRate;
        private final ItemStackMatcher[] cachedMatchers;
        IDrawerAttributes cachedAttrs;

        public FractionalStorage(FractionalDrawerGroup group, int slotCount) {
            this.group = group;
            this.slotCount = slotCount;
            this.protoStack = new ItemStack[slotCount];
            this.matchers = new ItemStackMatcher[slotCount];
            this.cachedProtoStack = new ItemStack[slotCount];
            this.cachedMatchers = new ItemStackMatcher[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.protoStack[i] = ItemStack.EMPTY;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.cachedProtoStack[i] = ItemStack.EMPTY;
                this.cachedMatchers[i] = ItemStackMatcher.EMPTY;
            }
            this.convRate = new int[slotCount];
            this.cachedConvRate = new int[slotCount];
        }

        @NotNull
        public IDrawerAttributes getAttributes() {
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            this.cachedAttrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            return EmptyDrawerAttributes.EMPTY;
        }

        public int getPooledCount() {
            return this.pooledCount;
        }

        public void setPooledCount(int count) {
            if (this.pooledCount != count) {
                this.pooledCount = count;
                this.group.onAmountChanged();
            }
        }

        @NotNull
        public ItemStack getStack(int slot) {
            return this.protoStack[slot];
        }

        @NotNull
        public ItemStack baseStack() {
            return this.protoStack[0];
        }

        public int baseRate() {
            return this.convRate[0];
        }

        public IFractionalDrawer setStoredItem(int slot, @NotNull ItemStack itemPrototype) {
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).isEmpty()) {
                this.reset();
                return this.group.getDrawer(slot);
            }
            if (this.baseRate() == 0) {
                this.populateSlots(itemPrototype);
                for (int i = 0; i < this.slotCount; ++i) {
                    if (!ItemStackMatcher.areItemsEqual(this.protoStack[i], itemPrototype)) continue;
                    slot = i;
                    this.pooledCount = 0;
                }
                this.group.onItemChanged();
            }
            return this.group.getDrawer(slot);
        }

        public int getStoredCount(int slot) {
            if (this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.pooledCount / this.convRate[slot];
        }

        public void setStoredItemCount(int slot, int amount) {
            if (this.convRate[slot] == 0) {
                return;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return;
            }
            int oldCount = this.pooledCount;
            this.pooledCount = this.pooledCount % this.convRate[slot] + this.convRate[slot] * amount;
            this.pooledCount = Math.min(this.pooledCount, this.getMaxCapacity(0) * this.convRate[0]);
            this.pooledCount = Math.max(this.pooledCount, 0);
            if (this.pooledCount == oldCount) {
                return;
            }
            if (this.pooledCount == 0 && !attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset();
            } else {
                this.group.onAmountChanged();
            }
        }

        public int adjustStoredItemCount(int slot, int amount) {
            if (this.convRate[slot] == 0 || amount == 0) {
                return Math.abs(amount);
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (amount > 0) {
                int canAdd;
                int willAdd;
                if (attrs.isUnlimitedVending()) {
                    return 0;
                }
                int poolMax = this.getMaxCapacity(0) * this.convRate[0];
                if (poolMax < 0) {
                    poolMax = Integer.MAX_VALUE;
                }
                if ((willAdd = Math.min(amount, canAdd = (poolMax - this.pooledCount) / this.convRate[slot])) > 0) {
                    this.pooledCount += this.convRate[slot] * willAdd;
                    this.group.onAmountChanged();
                }
                if (attrs.isVoid()) {
                    return 0;
                }
                return amount - willAdd;
            }
            int canRemove = this.pooledCount / this.convRate[slot];
            int willRemove = Math.min(amount = -amount, canRemove);
            if (willRemove == 0) {
                return amount;
            }
            this.pooledCount -= willRemove * this.convRate[slot];
            if (this.pooledCount == 0 && !attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset();
            } else {
                this.group.onAmountChanged();
            }
            return amount - willRemove;
        }

        public int getMaxCapacity(int slot) {
            if (this.baseStack().isEmpty() || this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedStorage() || attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE / this.convRate[slot];
            }
            int maxSize = ItemStackHelper.getMaxStackSize(this.baseStack());
            try {
                int cap = Math.multiplyExact(maxSize * this.baseRate(), this.group.getStackCapacity());
                return cap / this.convRate[slot];
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE / this.convRate[slot];
            }
        }

        public int getMaxCapacity(int slot, @NotNull ItemStack itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedStorage() || attrs.isUnlimitedVending()) {
                if (this.convRate[slot] == 0) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE / this.convRate[slot];
            }
            if (this.baseStack().isEmpty()) {
                int itemStackLimit = 64;
                if (!itemPrototype.isEmpty()) {
                    itemStackLimit = ItemStackHelper.getMaxStackSize(itemPrototype);
                }
                try {
                    return Math.multiplyExact(itemStackLimit, this.group.getStackCapacity());
                }
                catch (ArithmeticException e) {
                    return Integer.MAX_VALUE;
                }
            }
            if (ItemStackMatcher.areItemsEqual(this.protoStack[slot], itemPrototype)) {
                return this.getMaxCapacity(slot);
            }
            return 0;
        }

        public int getAcceptingMaxCapacity(int slot, @NotNull ItemStack itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(slot, itemPrototype);
        }

        public int getRemainingCapacity(int slot) {
            if (this.baseStack().isEmpty() || this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            int rawMaxCapacity = this.getMaxCapacity(0) * this.baseRate();
            int rawRemaining = rawMaxCapacity - this.pooledCount;
            return rawRemaining / this.convRate[slot];
        }

        public int getAcceptingRemainingCapacity(int slot) {
            if (this.baseStack().isEmpty() || this.convRate[slot] == 0) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending() || attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            int rawMaxCapacity = this.getMaxCapacity(0) * this.baseRate();
            int rawRemaining = rawMaxCapacity - this.pooledCount;
            return rawRemaining / this.convRate[slot];
        }

        public boolean isEmpty(int slot) {
            return this.protoStack[slot].isEmpty();
        }

        public boolean isEnabled(int slot) {
            if (this.baseStack().isEmpty()) {
                return true;
            }
            return !this.protoStack[slot].isEmpty();
        }

        public boolean canItemBeStored(int slot, @NotNull ItemStack itemPrototype, Predicate<ItemStack> predicate, boolean manualStore) {
            if (StorageBlacklist.INSTANCE.isBlacklisted(itemPrototype)) {
                return false;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (this.protoStack[slot].isEmpty() && this.protoStack[0].isEmpty() && (manualStore || !attrs.isItemLocked(LockAttribute.LOCK_EMPTY))) {
                return true;
            }
            if (predicate == null) {
                return this.matchers[slot].matches(itemPrototype);
            }
            return predicate.test(this.protoStack[slot]);
        }

        public boolean canItemBeExtracted(int slot, @NotNull ItemStack itemPrototype, Predicate<ItemStack> predicate) {
            if (this.protoStack[slot].isEmpty()) {
                return false;
            }
            if (predicate == null) {
                return this.matchers[slot].matches(itemPrototype);
            }
            return predicate.test(this.protoStack[slot]);
        }

        public int getConversionRate(int slot) {
            if (this.baseStack().isEmpty() || this.convRate[slot] == 0) {
                return 0;
            }
            return this.convRate[0] / this.convRate[slot];
        }

        public int getStoredItemRemainder(int slot) {
            if (this.convRate[slot] == 0) {
                return 0;
            }
            if (slot == 0) {
                return this.pooledCount / this.baseRate();
            }
            return this.pooledCount / this.convRate[slot] % (this.convRate[slot - 1] / this.convRate[slot]);
        }

        public boolean isSmallestUnit(int slot) {
            if (this.baseStack().isEmpty() || this.convRate[slot] == 0) {
                return false;
            }
            return this.convRate[slot] == 1;
        }

        private void reset() {
            this.pooledCount = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                this.protoStack[i] = ItemStack.EMPTY;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.convRate[i] = 0;
            }
            this.group.onItemChanged();
        }

        private void populateSlotsFromCache() {
            for (int slot = 0; slot < this.slotCount; ++slot) {
                this.protoStack[slot] = this.cachedProtoStack[slot];
                this.convRate[slot] = this.cachedConvRate[slot];
                this.matchers[slot] = this.cachedMatchers[slot];
            }
        }

        private void populateSlots(@NotNull ItemStack itemPrototype) {
            int i;
            IDrawerAttributes attrs = this.getAttributes();
            Level world = this.group.getWorld();
            if (world == null) {
                this.protoStack[0] = itemPrototype;
                this.convRate[0] = 1;
                this.matchers[0] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[0]) : new ItemStackMatcher(this.protoStack[0]);
                return;
            }
            if (ItemStackMatcher.areItemsEqual(itemPrototype, this.cacheKey)) {
                this.populateSlotsFromCache();
                return;
            }
            this.cacheKey = itemPrototype;
            CompactingHelper compacting = new CompactingHelper(world);
            Stack<CompactingHelper.Result> resultStack = new Stack<CompactingHelper.Result>();
            ItemStack lookupTarget = itemPrototype;
            int index = 0;
            if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.compacting.enabled.get()).booleanValue()) {
                CompactingHelper.Result lookup;
                for (int i2 = 0; i2 < this.slotCount - 1 && !(lookup = compacting.findHigherTier(lookupTarget)).getStack().isEmpty(); ++i2) {
                    resultStack.push(lookup);
                    lookupTarget = lookup.getStack();
                }
                int n = resultStack.size();
                while (index < n) {
                    CompactingHelper.Result result = (CompactingHelper.Result)resultStack.pop();
                    this.populateRawSlot(index, result.getStack(), result.getSize());
                    this.group.log("Picked candidate " + result.getStack().toString() + " with conv=" + result.getSize());
                    for (i = 0; i < index; ++i) {
                        int n2 = i;
                        this.convRate[n2] = this.convRate[n2] * result.getSize();
                        this.cachedConvRate[i] = this.convRate[i];
                    }
                    ++index;
                }
            }
            if (index == this.slotCount) {
                return;
            }
            this.populateRawSlot(index++, itemPrototype, 1);
            if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.compacting.enabled.get()).booleanValue()) {
                lookupTarget = itemPrototype;
                while (index < this.slotCount) {
                    CompactingHelper.Result lookup = compacting.findLowerTier(lookupTarget);
                    ItemStack itemStack = lookup.getStack();
                    if (!itemStack.isEmpty()) {
                        this.populateRawSlot(index, itemStack, 1);
                        this.group.log("Picked candidate " + String.valueOf(itemStack) + " with conv=" + lookup.getSize());
                        for (i = 0; i < index; ++i) {
                            int n = i;
                            this.convRate[n] = this.convRate[n] * lookup.getSize();
                            this.cachedConvRate[i] = this.convRate[i];
                        }
                    } else {
                        this.populateRawSlot(index, ItemStack.EMPTY, 0);
                    }
                    lookupTarget = itemStack;
                    ++index;
                }
            }
        }

        private void populateRawSlot(int slot, @NotNull ItemStack itemPrototype, int rate) {
            this.protoStack[slot] = itemPrototype;
            this.convRate[slot] = rate;
            IDrawerAttributes attrs = this.getAttributes();
            this.matchers[slot] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[slot]) : new ItemStackMatcher(this.protoStack[slot]);
            this.cachedProtoStack[slot] = itemPrototype;
            this.cachedConvRate[slot] = rate;
            this.cachedMatchers[slot] = this.matchers[slot];
        }

        private void normalizeGroup() {
            int i;
            for (int limit = this.slotCount - 1; limit > 0; --limit) {
                for (i = 0; i < limit; ++i) {
                    if (!this.protoStack[i].isEmpty()) continue;
                    this.protoStack[i] = this.protoStack[i + 1];
                    this.matchers[i] = this.matchers[i + 1];
                    this.convRate[i] = this.convRate[i + 1];
                    this.protoStack[i + 1] = ItemStack.EMPTY;
                    this.matchers[i + 1] = ItemStackMatcher.EMPTY;
                    this.convRate[i + 1] = 0;
                }
            }
            int minConvRate = Integer.MAX_VALUE;
            for (i = 0; i < this.slotCount; ++i) {
                if (this.convRate[i] <= 0) continue;
                minConvRate = Math.min(minConvRate, this.convRate[i]);
            }
            if (minConvRate > 1) {
                i = 0;
                while (i < this.slotCount) {
                    int n = i++;
                    this.convRate[n] = this.convRate[n] / minConvRate;
                }
                this.pooledCount /= minConvRate;
            }
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            ListTag itemList = new ListTag();
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.protoStack[i].isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag = (CompoundTag)this.protoStack[i].save(provider, (Tag)itemTag);
                CompoundTag slotTag = new CompoundTag();
                slotTag.putByte("Slot", (byte)i);
                slotTag.putInt("Conv", this.convRate[i]);
                slotTag.put("Item", (Tag)itemTag);
                itemList.add((Object)slotTag);
            }
            CompoundTag tag = new CompoundTag();
            tag.putInt("Count", this.pooledCount);
            tag.put("Items", (Tag)itemList);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            for (int i = 0; i < this.slotCount; ++i) {
                this.protoStack[i] = ItemStack.EMPTY;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.convRate[i] = 0;
            }
            this.pooledCount = tag.getInt("Count");
            ListTag itemList = tag.getList("Items", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                CompoundTag slotTag = itemList.getCompound(i);
                byte slot = slotTag.getByte("Slot");
                this.protoStack[slot] = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)slotTag.getCompound("Item"));
                this.convRate[slot] = slotTag.getByte("Conv");
                IDrawerAttributes attrs = this.getAttributes();
                this.matchers[slot] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[slot]) : new ItemStackMatcher(this.protoStack[slot]);
            }
            this.normalizeGroup();
            if (itemList.size() > 0) {
                boolean cacheMatch = true;
                for (int i = 0; i < this.slotCount; ++i) {
                    cacheMatch &= ItemStackMatcher.areItemsEqual(this.protoStack[i], this.cachedProtoStack[i]);
                    cacheMatch &= this.convRate[i] == this.cachedConvRate[i];
                }
                if (!cacheMatch) {
                    this.cacheKey = ItemStack.EMPTY;
                }
            }
        }

        public void syncAttributes() {
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.protoStack[i].isEmpty()) continue;
                IDrawerAttributes attrs = this.getAttributes();
                this.matchers[i] = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack[i]) : new ItemStackMatcher(this.protoStack[i]);
            }
        }
    }

    private static class FractionalDrawer
    implements IFractionalDrawer {
        private final FractionalStorage storage;
        private final int slot;

        private FractionalDrawer(FractionalStorage storage, int slot) {
            this.storage = storage;
            this.slot = slot;
        }

        private FractionalDrawer(FractionalDrawer data) {
            this(data.storage, data.slot);
        }

        @Override
        @NotNull
        public ItemStack getStoredItemPrototype() {
            return this.storage.getStack(this.slot);
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull ItemStack itemPrototype) {
            if (ItemStackHelper.isStackEncoded(itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype(itemPrototype);
            }
            return this.storage.setStoredItem(this.slot, itemPrototype);
        }

        @Override
        public int getStoredItemCount() {
            return this.storage.getStoredCount(this.slot);
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.storage.setStoredItemCount(this.slot, amount);
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.storage.adjustStoredItemCount(this.slot, amount);
        }

        @Override
        public int getMaxCapacity() {
            return this.storage.getMaxCapacity(this.slot);
        }

        @Override
        public int getMaxCapacity(@NotNull ItemStack itemPrototype) {
            return this.storage.getMaxCapacity(this.slot, itemPrototype);
        }

        @Override
        public int getAcceptingMaxCapacity(@NotNull ItemStack itemPrototype) {
            return this.storage.getAcceptingMaxCapacity(this.slot, itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            return this.storage.getRemainingCapacity(this.slot);
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            return this.storage.getAcceptingRemainingCapacity(this.slot);
        }

        @Override
        public boolean canItemBeStored(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            return this.storage.canItemBeStored(this.slot, itemPrototype, matchPredicate, false);
        }

        @Override
        public boolean canItemBeStoredManual(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            return this.storage.canItemBeStored(this.slot, itemPrototype, matchPredicate, true);
        }

        @Override
        public boolean canItemBeExtracted(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            return this.storage.canItemBeExtracted(this.slot, itemPrototype, matchPredicate);
        }

        @Override
        public boolean isEmpty() {
            return this.storage.isEmpty(this.slot);
        }

        @Override
        public boolean isEnabled() {
            return this.storage.isEnabled(this.slot);
        }

        @Override
        public int getConversionRate() {
            return this.storage.getConversionRate(this.slot);
        }

        @Override
        public int getStoredItemRemainder() {
            return this.storage.getStoredItemRemainder(this.slot);
        }

        @Override
        public boolean isSmallestUnit() {
            return this.storage.isSmallestUnit(this.slot);
        }

        @Override
        @NotNull
        public IDrawerAttributes getAttributes() {
            return this.storage.getAttributes();
        }

        @Override
        public IFractionalDrawer copy() {
            return new FractionalDrawer(this);
        }
    }
}

