/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.PlatformHelperClient;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CameraStandEntityRenderer<T extends CameraStandEntity>
extends EntityRenderer<T> {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/item/camera.png");
    public static final float MOUNT_SCALE = 0.9f;
    protected final BlockRenderDispatcher blockRenderer;

    public CameraStandEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    @NotNull
    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE_LOCATION;
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        float hurtTime = (float)((CameraStandEntity)entity).getHurtTime() - partialTick;
        float damage = Math.max(0.0f, ((CameraStandEntity)entity).getDamage() - partialTick);
        if (hurtTime > 0.0f) {
            float rotation = Mth.sin((float)hurtTime) * hurtTime * damage / 10.0f * (float)((CameraStandEntity)entity).getHurtDir();
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            poseStack.mulPose(Axis.XP.rotationDegrees(rotation));
        }
        float entityPitch = Mth.lerp((float)partialTick, (float)((CameraStandEntity)entity).xRotO, (float)entity.getXRot());
        this.renderStand(entity, entityYaw, entityPitch, partialTick, poseStack, bufferSource, packedLight);
        this.renderMount(entity, entityYaw, entityPitch, partialTick, poseStack, bufferSource, packedLight);
        if (!((CameraStandEntity)entity).getCamera().isEmpty()) {
            this.renderCamera(entity, entityYaw, entityPitch, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    private void renderStand(T entity, float entityYaw, float entityPitch, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        if (entity.getVehicle() != null) {
            float vehicleRot = Mth.lerp((float)partialTick, (float)entity.getVehicle().yRotO, (float)entity.getVehicle().getYRot());
            poseStack.mulPose(Axis.YP.rotationDegrees(-vehicleRot + 45.0f));
        }
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        ModelResourceLocation modelLocation = ExposureClient.Models.CAMERA_STAND;
        BakedModel model = PlatformHelperClient.getModel(modelLocation);
        this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(RenderType.solid()), null, model, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private void renderMount(T entity, float entityYaw, float entityPitch, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0, 1.125, 0.0);
        float scale = 0.9f;
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotationDegrees(-entityYaw + 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(-entityPitch));
        if (((CameraStandEntity)entity).isMalfunctioned()) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-50.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(-10.0f));
        }
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        ModelResourceLocation mountModelLocation = ExposureClient.Models.CAMERA_STAND_MOUNT;
        BakedModel mountModel = PlatformHelperClient.getModel(mountModelLocation);
        this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(RenderType.solid()), null, mountModel, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private void renderCamera(T entity, float entityYaw, float entityPitch, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float f;
        ItemStack camera;
        Item item;
        poseStack.pushPose();
        poseStack.translate(0.0, 1.125, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(-entityYaw + 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(-entityPitch));
        poseStack.translate(0.0, (double)0.1125f, 0.0);
        if (((CameraStandEntity)entity).isMalfunctioned()) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-50.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(-15.0f));
        }
        if ((item = (camera = ((CameraStandEntity)entity).getCamera()).getItem()) instanceof CameraItem) {
            CameraItem cameraItem = (CameraItem)item;
            f = cameraItem.getScaleOnStand();
        } else {
            f = 0.9f;
        }
        float scale = f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0, 0.5, 0.0);
        Minecrft.get().getItemRenderer().renderStatic(camera, ItemDisplayContext.NONE, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, entity.level(), 0);
        poseStack.popPose();
    }
}

