/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.input;

import io.github.mortuusars.exposure.client.input.KeyBinding;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;

@FunctionalInterface
public interface Key {
    public boolean matches(int var1, int var2, int var3, int var4);

    default public Key or(Key anotherKey) {
        return (key, code, action, mods) -> this.matches(key, code, action, mods) || anotherKey.matches(key, code, action, mods);
    }

    default public KeyWithPredicate onlyIf(Supplier<Boolean> predicate) {
        return new KeyWithPredicate(this, predicate);
    }

    default public KeyBinding executes(Supplier<Boolean> handler) {
        return new KeyBinding(this, handler);
    }

    default public KeyBinding executes(Runnable runnable) {
        return new KeyBinding(this, () -> {
            runnable.run();
            return true;
        });
    }

    public static boolean actionMatches(int definedAction, int action) {
        if (definedAction == 1 || definedAction == 2) {
            return action == 1 || action == 2;
        }
        return definedAction == action;
    }

    public static Key press(int keyCode) {
        return Key.press(0, keyCode);
    }

    public static Key release(int keyCode) {
        return Key.release(0, keyCode);
    }

    public static Key press(int modifiers, int keyCode) {
        return (key, code, action, mods) -> Key.actionMatches(1, action) && keyCode == key && mods == modifiers;
    }

    public static Key release(int modifiers, int keyCode) {
        return (key, code, action, mods) -> Key.actionMatches(0, action) && keyCode == key && mods == modifiers;
    }

    public static Key press(KeyMapping keyMapping) {
        return (key, code, action, mods) -> Key.actionMatches(1, action) && keyMapping.matches(key, code);
    }

    public static Key release(KeyMapping keyMapping) {
        return (key, code, action, mods) -> Key.actionMatches(0, action) && keyMapping.matches(key, code);
    }

    public record KeyWithPredicate(Key key, Supplier<Boolean> predicate) implements Key
    {
        @Override
        public boolean matches(int keyCode, int scanCode, int action, int modifiers) {
            return this.key.matches(keyCode, scanCode, action, modifiers) && this.predicate.get() != false;
        }
    }
}

