/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import io.github.mortuusars.exposure.util.color.converter.HUSLColorConverter;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class AgedHSLUVEffect
implements PixelEffect {
    protected final int tintColor;
    protected final double[] tintColorHsluv;
    protected final float tintOpacity;
    protected final int blackPoint;
    protected final int whitePoint;

    public AgedHSLUVEffect(int tintColor, float tintOpacity, int blackPoint, int whitePoint) {
        this.tintColor = tintColor;
        String hexStr = StringUtils.leftPad((String)Integer.toHexString(tintColor & 0xFFFFFF), (int)6, (String)"0");
        this.tintColorHsluv = HUSLColorConverter.hexToHsluv("#" + hexStr);
        this.tintOpacity = tintOpacity;
        this.blackPoint = blackPoint & 0xFF;
        this.whitePoint = whitePoint & 0xFF;
    }

    @Override
    public String getIdentifier() {
        return "aged";
    }

    @Override
    public int modify(int colorARGB) {
        int alpha = FastColor.ARGB32.alpha((int)colorARGB);
        int red = FastColor.ARGB32.red((int)colorARGB);
        int green = FastColor.ARGB32.green((int)colorARGB);
        int blue = FastColor.ARGB32.blue((int)colorARGB);
        red = (int)Mth.map((float)red, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        green = (int)Mth.map((float)green, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        blue = (int)Mth.map((float)blue, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f});
        hsluv[0] = this.tintColorHsluv[0];
        hsluv[1] = this.tintColorHsluv[1];
        double[] rgb = HUSLColorConverter.hsluvToRgb(hsluv);
        int newRed = Mth.clamp((int)((int)Mth.lerp((double)this.tintOpacity, (double)red, (double)(rgb[0] * 255.0))), (int)0, (int)255);
        int newGreen = Mth.clamp((int)((int)Mth.lerp((double)this.tintOpacity, (double)green, (double)(rgb[1] * 255.0))), (int)0, (int)255);
        int newBlue = Mth.clamp((int)((int)Mth.lerp((double)this.tintOpacity, (double)blue, (double)(rgb[2] * 255.0))), (int)0, (int)255);
        return FastColor.ARGB32.color((int)alpha, (int)newRed, (int)newGreen, (int)newBlue);
    }

    public String toString() {
        return "AgedHSLUVPixelModifier{tintColor=#" + Integer.toHexString(this.tintColor) + ", tintOpacity=" + this.tintOpacity + ", blackPoint=" + this.blackPoint + ", whitePoint=" + this.whitePoint + "}";
    }
}

