/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.resources.ResourceLocation;

public interface ToastIcon {
    public static final ToastIcon MOVEMENT_KEYS = new TutorialIcon(TutorialToast.Icons.MOVEMENT_KEYS);
    public static final ToastIcon MOUSE = new TutorialIcon(TutorialToast.Icons.MOUSE);
    public static final ToastIcon TREE = new TutorialIcon(TutorialToast.Icons.TREE);
    public static final ToastIcon RECIPE_BOOK = new TutorialIcon(TutorialToast.Icons.RECIPE_BOOK);
    public static final ToastIcon WOODEN_PLANKS = new TutorialIcon(TutorialToast.Icons.WOODEN_PLANKS);
    public static final ToastIcon SOCIAL_INTERACTIONS = new TutorialIcon(TutorialToast.Icons.SOCIAL_INTERACTIONS);
    public static final ToastIcon RIGHT_CLICK = new TutorialIcon(TutorialToast.Icons.RIGHT_CLICK);
    public static final ToastIcon HOVER = new SpriteIcon(Exposure.resource("toast/hover"));
    public static final ToastIcon F1 = new SpriteIcon(Exposure.resource("toast/f1"));
    public static final ToastIcon HEADS_UP = new SpriteIcon(Exposure.resource("toast/heads_up"));

    public void render(GuiGraphics var1, int var2, int var3);

    public static class TutorialIcon
    implements ToastIcon {
        protected final TutorialToast.Icons icon;

        public TutorialIcon(TutorialToast.Icons icon) {
            this.icon = icon;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y) {
            this.icon.render(guiGraphics, x, y);
        }
    }

    public static class SpriteIcon
    implements ToastIcon {
        protected final ResourceLocation sprite;

        public SpriteIcon(ResourceLocation sprite) {
            this.sprite = sprite;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y) {
            RenderSystem.enableBlend();
            guiGraphics.blitSprite(this.sprite, x, y, 20, 20);
        }
    }
}

