/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.template;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CaptureTemplates {
    private static final Map<ResourceLocation, CaptureTemplate> TEMPLATES = new HashMap<ResourceLocation, CaptureTemplate>();

    public static void register(ResourceLocation id, CaptureTemplate template) {
        Preconditions.checkState((!TEMPLATES.containsKey(id) ? 1 : 0) != 0, (String)"Template with id '%s' is already registered.", (Object)id);
        TEMPLATES.put(id, template);
    }

    @Nullable
    public static CaptureTemplate get(ResourceLocation id) {
        return TEMPLATES.get(id);
    }

    public static CaptureTemplate getOrThrow(ResourceLocation id) {
        @Nullable CaptureTemplate template = TEMPLATES.get(id);
        Preconditions.checkNotNull((Object)template, (String)"No template for id '%s' is registered.", (Object)id);
        return template;
    }
}

