/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.util;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public final class SpriteCalculator {
    private static final BlockModelShaper MODELS = Minecraft.getInstance().getModelManager().getBlockModelShaper();

    public static TextureAtlasSprite calculateSprite(BlockState state, Direction face, Supplier<RandomSource> randomSupplier) {
        BakedModel model = MODELS.getBlockModel(state);
        List quads = model.getQuads(state, face, randomSupplier.get());
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.getFirst()).getSprite();
        }
        quads = model.getQuads(state, null, randomSupplier.get());
        if (!quads.isEmpty()) {
            for (BakedQuad quad : quads) {
                if (quad.getDirection() != face) continue;
                return quad.getSprite();
            }
        }
        return null;
    }
}

