/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.model;

import dev.ultimatchamp.bettergrass.compat.WilderWildCompat;
import dev.ultimatchamp.bettergrass.config.BetterGrassifyConfig;
import dev.ultimatchamp.bettergrass.util.SpriteCalculator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BetterGrassifyBakedModel
extends ForwardingBakedModel {
    public static List<Block> BETTER_SNOW_CACHE = new CopyOnWriteArrayList<Block>();
    public static List<Map.Entry<Block, String>> EXCLUDED_BLOCKS_CACHE = new CopyOnWriteArrayList<Map.Entry<Block, String>>();
    public static List<TagKey<Block>> EXCLUDED_TAGS_CACHE = new CopyOnWriteArrayList<TagKey<Block>>();
    public static List<Map.Entry<Block, String>> WHITELISTED_BLOCKS_CACHE = new CopyOnWriteArrayList<Map.Entry<Block, String>>();
    public static List<TagKey<Block>> WHITELISTED_TAGS_CACHE = new CopyOnWriteArrayList<TagKey<Block>>();

    public BetterGrassifyBakedModel(BakedModel baseModel) {
        this.wrapped = baseModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        context.pushTransform(quad -> {
            if (!BetterGrassifyConfig.load().betterGrassMode.equals((Object)BetterGrassifyConfig.BetterGrassMode.OFF)) {
                Direction face = quad.nominalFace();
                if (face == null || face.getAxis().isVertical() || state.hasBlockEntity() || !BetterGrassifyBakedModel.isFullQuad(quad)) {
                    return true;
                }
                this.betterGrassify(quad, blockView, state, pos, face, randomSupplier);
            }
            return true;
        });
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    public void betterGrassify(MutableQuadView quad, BlockAndTintGetter world, BlockState state, BlockPos pos, Direction face, Supplier<RandomSource> randomSupplier) {
        if (state.is(Blocks.DIRT) && BetterGrassifyBakedModel.isBelowNonFullBlock(world, pos, face)) {
            BetterGrassifyBakedModel.dirtSpriteBake(quad, world, pos, randomSupplier);
            return;
        }
        if (BetterGrassifyConfig.load().betterGrassMode.equals((Object)BetterGrassifyConfig.BetterGrassMode.FANCY)) {
            if (BetterGrassifyBakedModel.canFullyConnect(world, state, pos, face)) {
                if (BetterGrassifyBakedModel.isSnowy(world, pos)) {
                    BetterGrassifyBakedModel.spriteBake(quad, world.getBlockState(pos.above()), randomSupplier);
                    return;
                }
                BetterGrassifyBakedModel.spriteBake(quad, state, randomSupplier);
            } else {
                this.betterSnowyGrass(quad, world, pos, face, randomSupplier);
            }
        } else {
            if (BetterGrassifyBakedModel.isSnowy(world, pos)) {
                BetterGrassifyBakedModel.spriteBake(quad, world.getBlockState(pos.above()), randomSupplier);
                return;
            }
            if (BetterGrassifyBakedModel.canHaveGhostSnowLayer(world, pos.above())) {
                if (!BetterGrassifyConfig.load().snowy) {
                    return;
                }
                BetterGrassifyBakedModel.spriteBake(quad, BetterGrassifyBakedModel.getLayerNeighbour(world, pos.above()), randomSupplier);
                return;
            }
            BetterGrassifyBakedModel.spriteBake(quad, world.getBlockState(pos), randomSupplier);
        }
    }

    public void betterSnowyGrass(MutableQuadView quad, BlockAndTintGetter world, BlockPos pos, Direction face, Supplier<RandomSource> randomSupplier) {
        BlockPos adjacentPos = pos.relative(face);
        if (BetterGrassifyBakedModel.isSnowy(world, pos) && BetterGrassifyBakedModel.canHaveGhostSnowLayer(world, adjacentPos)) {
            BetterGrassifyBakedModel.spriteBake(quad, world.getBlockState(pos.above()), randomSupplier);
        } else if (BetterGrassifyBakedModel.canHaveGhostSnowLayer(world, pos.above()) && BetterGrassifyBakedModel.isSnowy(world, adjacentPos.below())) {
            BetterGrassifyBakedModel.spriteBake(quad, world.getBlockState(adjacentPos), randomSupplier);
        } else if (BetterGrassifyBakedModel.canHaveGhostSnowLayer(world, pos.above()) && BetterGrassifyBakedModel.canHaveGhostSnowLayer(world, adjacentPos)) {
            if (!BetterGrassifyConfig.load().snowy) {
                return;
            }
            BetterGrassifyBakedModel.spriteBake(quad, BetterGrassifyBakedModel.getLayerNeighbour(world, pos.above()), randomSupplier);
        }
    }

    private static boolean isFullQuad(MutableQuadView quad) {
        if (!BetterGrassifyConfig.load().resourcePackCompatibilityMode) {
            return true;
        }
        float tolerance = 0.0625f;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (int i = 0; i < 4; ++i) {
            float y = quad.y(i);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return minY <= tolerance && maxY >= 1.0f - tolerance;
    }

    private static boolean canFullyConnect(BlockAndTintGetter world, BlockState self, BlockPos selfPos, Direction direction) {
        return BetterGrassifyBakedModel.canConnect(world, self, selfPos, selfPos.relative(direction).below());
    }

    private static boolean canConnect(BlockAndTintGetter world, BlockState self, BlockPos selfPos, BlockPos adjacentPos) {
        BlockState adjacent = world.getBlockState(adjacentPos);
        BlockPos upPos = adjacentPos.above();
        BlockState up = world.getBlockState(upPos);
        return BetterGrassifyBakedModel.canConnect(self, adjacent) && (up.isAir() || BetterGrassifyBakedModel.isSnowy(world, selfPos) || !up.isFaceSturdy((BlockGetter)world, upPos, Direction.DOWN));
    }

    private static boolean canConnect(BlockState self, BlockState adjacent) {
        return self == adjacent;
    }

    private static boolean isBelowNonFullBlock(BlockAndTintGetter world, BlockPos selfPos, Direction direction) {
        BlockPos upPos = selfPos.above();
        BlockState up = world.getBlockState(upPos);
        if (!up.getBlock().equals(Blocks.DIRT_PATH) && !up.getBlock().equals(Blocks.FARMLAND)) {
            return false;
        }
        if (up.getBlock().equals(Blocks.DIRT_PATH) && !BetterGrassifyConfig.load().dirtPaths) {
            return false;
        }
        if (up.getBlock().equals(Blocks.FARMLAND) && !BetterGrassifyConfig.load().farmLands) {
            return false;
        }
        return BetterGrassifyBakedModel.canFullyConnect(world, up, upPos, direction);
    }

    private static boolean isSnowy(BlockAndTintGetter world, BlockPos selfPos) {
        if (FabricLoader.getInstance().isModLoaded("wilderwild") && WilderWildCompat.isSnowloggingOn()) {
            return false;
        }
        BlockState self = world.getBlockState(selfPos);
        return self.getOptionalValue((Property)BlockStateProperties.SNOWY).orElse(false) != false && !world.getBlockState(selfPos.above()).isAir();
    }

    public static BlockState getLayerNeighbour(BlockAndTintGetter world, BlockPos selfPos) {
        if (BETTER_SNOW_CACHE.isEmpty()) {
            for (String id : BetterGrassifyConfig.load().snowLayers) {
                ResourceLocation identifier = ResourceLocation.tryParse((String)id);
                Optional layer = BuiltInRegistries.BLOCK.getOptional(identifier);
                if (layer.isEmpty()) continue;
                BETTER_SNOW_CACHE.add((Block)layer.get());
            }
        }
        for (Block layer : BETTER_SNOW_CACHE) {
            boolean layerCheck;
            BlockPos[] directions = new BlockPos[]{selfPos.north(), selfPos.south(), selfPos.east(), selfPos.west()};
            boolean[] isLayer = new boolean[4];
            for (int i = 0; i < 4; ++i) {
                BlockState state = world.getBlockState(directions[i]);
                isLayer[i] = state.is(layer) || layer.defaultBlockState().is(Blocks.SNOW) && (state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.POWDER_SNOW));
            }
            switch (BetterGrassifyConfig.load().betterSnowMode) {
                case OPTIFINE: {
                    boolean bl;
                    if (isLayer[0] || isLayer[1] || isLayer[2] || isLayer[3]) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case LAMBDA: {
                    boolean bl;
                    if ((isLayer[0] || isLayer[1]) && (isLayer[2] || isLayer[3]) || isLayer[0] && isLayer[1] || isLayer[2] && isLayer[3]) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = layerCheck = false;
                }
            }
            if (!layerCheck) continue;
            for (BlockPos direction : directions) {
                BlockState state = world.getBlockState(direction);
                if (layer.defaultBlockState().is(Blocks.SNOW) && (state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.POWDER_SNOW))) {
                    return layer.defaultBlockState();
                }
                if (layer.defaultBlockState().is(Blocks.PINK_PETALS)) {
                    return (BlockState)layer.defaultBlockState().setValue((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable)Integer.valueOf(4));
                }
                if (!state.is(layer)) continue;
                return state;
            }
        }
        return null;
    }

    public static boolean isLayerNeighbourSnow(BlockAndTintGetter world, BlockPos selfPos) {
        BlockState layerNeighbour = BetterGrassifyBakedModel.getLayerNeighbour(world, selfPos);
        return layerNeighbour != null && (layerNeighbour.is(Blocks.SNOW) || layerNeighbour.is(Blocks.SNOW_BLOCK) || layerNeighbour.is(Blocks.POWDER_SNOW));
    }

    public static boolean canHaveGhostSnowLayer(BlockAndTintGetter world, BlockPos selfPos) {
        return BetterGrassifyBakedModel.canHaveGhostLayer(world, selfPos) && BetterGrassifyBakedModel.isLayerNeighbourSnow(world, selfPos);
    }

    public static boolean canHaveGhostLayer(BlockAndTintGetter world, BlockPos selfPos) {
        boolean isLayer;
        if (BetterGrassifyConfig.load().betterSnowMode == BetterGrassifyConfig.BetterSnowMode.OFF) {
            return false;
        }
        if (FabricLoader.getInstance().isModLoaded("wilderwild") && WilderWildCompat.isSnowloggingOn()) {
            return false;
        }
        BlockState self = world.getBlockState(selfPos);
        VoxelShape outlineShape = self.getShape((BlockGetter)world, selfPos);
        VoxelShape bottomFace = outlineShape.getFaceShape(Direction.DOWN);
        double height = outlineShape.max(Direction.Axis.Y) - outlineShape.min(Direction.Axis.Y);
        boolean isWhitelistedBlock = BetterGrassifyBakedModel.isBlockWhitelisted(self);
        if (!(isWhitelistedBlock || !self.isAir() && !self.is(Blocks.WATER) && !self.hasBlockEntity() && bottomFace.min(Direction.Axis.X) > 0.0 && bottomFace.max(Direction.Axis.X) < 1.0 && bottomFace.min(Direction.Axis.Z) > 0.0 && bottomFace.max(Direction.Axis.Z) < 1.0 && !(height <= 0.125))) {
            return false;
        }
        boolean bl = isLayer = BetterGrassifyBakedModel.getLayerNeighbour(world, selfPos) != null;
        if (!isLayer || !world.getBlockState(selfPos.below()).isFaceSturdy((BlockGetter)world, selfPos.below(), Direction.UP)) {
            return false;
        }
        boolean isWhitelistedTag = BetterGrassifyBakedModel.isTagWhitelisted(self);
        if (BetterGrassifyBakedModel.isWhitelistOn()) {
            return isWhitelistedBlock || isWhitelistedTag;
        }
        boolean isExcludedBlock = BetterGrassifyBakedModel.isBlockExcluded(self);
        boolean isExcludedTag = BetterGrassifyBakedModel.isTagExcluded(self);
        return !isExcludedBlock && !isExcludedTag;
    }

    private static boolean isBlockWhitelisted(BlockState self) {
        if (WHITELISTED_BLOCKS_CACHE.isEmpty()) {
            for (String string : BetterGrassifyConfig.load().whitelistedBlocks) {
                ResourceLocation identifier = ResourceLocation.tryParse((String)BetterGrassifyBakedModel.withoutAttribute(string));
                Optional whitelistedBlock = BuiltInRegistries.BLOCK.getOptional(identifier);
                if (whitelistedBlock.isEmpty()) continue;
                WHITELISTED_BLOCKS_CACHE.add(Map.entry((Block)whitelistedBlock.get(), string));
            }
        }
        for (Map.Entry entry : WHITELISTED_BLOCKS_CACHE) {
            if (!BetterGrassifyBakedModel.matchesBlock(self, (String)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTagWhitelisted(BlockState self) {
        if (WHITELISTED_TAGS_CACHE.isEmpty()) {
            for (String string : BetterGrassifyConfig.load().whitelistedTags) {
                ResourceLocation identifier = ResourceLocation.tryParse((String)string);
                WHITELISTED_TAGS_CACHE.add((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier));
            }
        }
        for (TagKey tagKey : WHITELISTED_TAGS_CACHE) {
            if (!self.is(tagKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockExcluded(BlockState self) {
        if (EXCLUDED_BLOCKS_CACHE.isEmpty()) {
            for (String string : BetterGrassifyConfig.load().excludedBlocks) {
                ResourceLocation identifier = ResourceLocation.tryParse((String)BetterGrassifyBakedModel.withoutAttribute(string));
                Optional excludedBlock = BuiltInRegistries.BLOCK.getOptional(identifier);
                if (excludedBlock.isEmpty()) continue;
                EXCLUDED_BLOCKS_CACHE.add(Map.entry((Block)excludedBlock.get(), string));
            }
        }
        for (Map.Entry entry : EXCLUDED_BLOCKS_CACHE) {
            if (!BetterGrassifyBakedModel.matchesBlock(self, (String)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTagExcluded(BlockState self) {
        if (EXCLUDED_TAGS_CACHE.isEmpty()) {
            for (String string : BetterGrassifyConfig.load().excludedTags) {
                ResourceLocation identifier = ResourceLocation.tryParse((String)string);
                EXCLUDED_TAGS_CACHE.add((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier));
            }
        }
        for (TagKey tagKey : EXCLUDED_TAGS_CACHE) {
            if (!self.is(tagKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesBlock(BlockState self, String block) {
        Optional blockCheck;
        boolean hasAttribute = block.contains("[");
        String blockName = BetterGrassifyBakedModel.withoutAttribute(block);
        String attribute = "";
        boolean attributeEnabled = true;
        if (hasAttribute) {
            attribute = block.contains("=") ? block.substring(block.indexOf("[") + 1, block.indexOf("=")) : block.substring(block.indexOf("[") + 1, block.indexOf("]"));
            boolean bl = attributeEnabled = !block.contains("=false");
        }
        if ((blockCheck = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse((String)blockName))).isEmpty()) {
            return false;
        }
        if (self.getBlock().equals(blockCheck.get())) {
            return !hasAttribute || self.toString().contains(attribute + "=" + attributeEnabled);
        }
        return false;
    }

    private static String withoutAttribute(String block) {
        int attributeIndex = block.indexOf("[");
        return attributeIndex > 0 ? block.substring(0, attributeIndex) : block;
    }

    private static boolean isWhitelistOn() {
        return !BetterGrassifyConfig.load().whitelistedBlocks.isEmpty() || !BetterGrassifyConfig.load().whitelistedTags.isEmpty();
    }

    private static void spriteBake(MutableQuadView quad, BlockState state, Supplier<RandomSource> randomSupplier) {
        TextureAtlasSprite sprite = SpriteCalculator.calculateSprite(state, Direction.UP, randomSupplier);
        if (sprite != null) {
            quad.spriteBake(sprite, 4);
        }
    }

    private static void dirtSpriteBake(MutableQuadView quad, BlockAndTintGetter world, BlockPos selfPos, Supplier<RandomSource> randomSupplier) {
        BlockPos upPos = selfPos.above();
        BlockState up = world.getBlockState(upPos);
        TextureAtlasSprite sprite = SpriteCalculator.calculateSprite(up, Direction.UP, randomSupplier);
        if (sprite != null) {
            quad.spriteBake(sprite, 4);
        }
    }
}

