/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.config;

import blue.endless.jankson.Comment;
import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import com.google.common.collect.Lists;
import dev.ultimatchamp.bettergrass.BetterGrassify;
import dev.ultimatchamp.bettergrass.config.BetterGrassifyGui;
import dev.ultimatchamp.bettergrass.config.NoYACLWarning;
import dev.ultimatchamp.bettergrass.model.BetterGrassifyBakedModel;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.tags.TagKey;
import net.minecraft.util.OptionEnum;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BetterGrassifyConfig {
    @Comment(value="-> General\nOFF/FAST/FANCY (default: FANCY)")
    public BetterGrassMode betterGrassMode = BetterGrassMode.FANCY;
    @Comment(value="(default: true)")
    public boolean resourcePackCompatibilityMode = true;
    @Comment(value="Blocks\n(default: true)")
    public boolean grassBlocks = true;
    @Comment(value="(default: true)")
    public boolean snowy = true;
    @Comment(value="(default: true)")
    public boolean dirtPaths = true;
    @Comment(value="(default: true)")
    public boolean farmLands = true;
    @Comment(value="(default: true)")
    public boolean podzol = true;
    @Comment(value="(default: true)")
    public boolean mycelium = true;
    @Comment(value="(default: true)")
    public boolean crimsonNylium = true;
    @Comment(value="(default: true)")
    public boolean warpedNylium = true;
    public List<String> moreBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:sculk_catalyst"});
    @Comment(value="-> Better Snow\nOFF/OPTIFINE/LAMBDA (default: LAMBDA)")
    public BetterSnowMode betterSnowMode = BetterSnowMode.LAMBDA;
    public List<String> snowLayers = Lists.newArrayList((Object[])new String[]{"snow", "moss_carpet", "pink_petals"});
    public List<String> excludedTags = Lists.newArrayList();
    public List<String> excludedBlocks = Lists.newArrayList((Object[])new String[]{"lantern[hanging]", "redstone_wall_torch", "soul_lantern[hanging]", "soul_wall_torch", "wall_torch"});
    public List<String> whitelistedTags = new ArrayList<String>();
    public List<String> whitelistedBlocks = new ArrayList<String>();
    private static final Jankson JANKSON = Jankson.builder().build();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("bettergrass.json5");
    private static BetterGrassifyConfig cachedConfig;

    public static BetterGrassifyConfig load() {
        BetterGrassifyConfig config;
        if (cachedConfig != null) {
            return cachedConfig;
        }
        BetterGrassifyConfig.initializeCaches();
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                BetterGrassify.LOGGER.info("[BetterGrassify] Config file not found. Creating a new one...");
                config = new BetterGrassifyConfig();
                BetterGrassifyConfig.save(config);
            } else {
                String configContent = Files.readString(CONFIG_PATH).trim();
                if (!configContent.startsWith("{") || !configContent.endsWith("}")) {
                    BetterGrassify.LOGGER.warn("[BetterGrassify] Config file is empty or invalid. Creating a new one...");
                    config = new BetterGrassifyConfig();
                    BetterGrassifyConfig.save(config);
                } else {
                    JsonObject configJson = BetterGrassifyConfig.ensureDefaults(JANKSON.load(configContent));
                    config = (BetterGrassifyConfig)JANKSON.fromJson(configJson, BetterGrassifyConfig.class);
                }
            }
        }
        catch (SyntaxError | IOException e) {
            BetterGrassify.LOGGER.error("[BetterGrassify]", e);
            config = new BetterGrassifyConfig();
            BetterGrassifyConfig.save(config);
        }
        cachedConfig = config;
        return cachedConfig;
    }

    public static void initializeCaches() {
        BetterGrassifyBakedModel.BETTER_SNOW_CACHE = new CopyOnWriteArrayList<Block>();
        BetterGrassifyBakedModel.EXCLUDED_BLOCKS_CACHE = new CopyOnWriteArrayList<Map.Entry<Block, String>>();
        BetterGrassifyBakedModel.EXCLUDED_TAGS_CACHE = new CopyOnWriteArrayList<TagKey<Block>>();
        BetterGrassifyBakedModel.WHITELISTED_BLOCKS_CACHE = new CopyOnWriteArrayList<Map.Entry<Block, String>>();
        BetterGrassifyBakedModel.WHITELISTED_TAGS_CACHE = new CopyOnWriteArrayList<TagKey<Block>>();
    }

    public static void save(BetterGrassifyConfig config) {
        try {
            String jsonString = JANKSON.toJson((Object)config).toJson(true, true);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)jsonString, new OpenOption[0]);
            cachedConfig = config;
        }
        catch (IOException e) {
            BetterGrassify.LOGGER.error("[BetterGrassify]", (Throwable)e);
        }
    }

    private static JsonObject ensureDefaults(JsonObject configJson) {
        boolean modified = false;
        BetterGrassifyConfig defaultConfig = new BetterGrassifyConfig();
        for (Field field : BetterGrassifyConfig.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                String fieldName = field.getName();
                Object defaultValue = field.get(defaultConfig);
                if (configJson.containsKey((Object)fieldName)) continue;
                BetterGrassify.LOGGER.info("[BetterGrassify] Missing config field '{}'. Re-saving as default.", (Object)fieldName);
                configJson.put(fieldName, JANKSON.toJson(defaultValue));
                modified = true;
            }
            catch (IllegalAccessException e) {
                BetterGrassify.LOGGER.error("[BetterGrassify] Failed to access field '{}'", (Object)field.getName(), (Object)e);
            }
        }
        if (modified) {
            BetterGrassifyConfig config = (BetterGrassifyConfig)JANKSON.fromJson(configJson, BetterGrassifyConfig.class);
            BetterGrassifyConfig.save(config);
        }
        return configJson;
    }

    public static Screen createConfigScreen(Screen parent) {
        if (FabricLoader.getInstance().isModLoaded("yet_another_config_lib_v3")) {
            return BetterGrassifyGui.createConfigScreen(parent);
        }
        return new NoYACLWarning(parent);
    }

    public static enum BetterGrassMode implements OptionEnum
    {
        OFF(0, "options.off"),
        FAST(1, "options.graphics.fast"),
        FANCY(2, "options.graphics.fancy");

        private final int id;
        private final String key;

        private BetterGrassMode(int id, String key) {
            this.id = id;
            this.key = key;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }

    public static enum BetterSnowMode implements OptionEnum
    {
        OFF(0, "options.off"),
        OPTIFINE(1, "bettergrass.betterSnowMode.optifine"),
        LAMBDA(2, "bettergrass.betterSnowMode.lambda");

        private final int id;
        private final String key;

        private BetterSnowMode(int id, String key) {
            this.id = id;
            this.key = key;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }
}

