/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.recipe;

import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.jei.EnchantingApparatusRecipeCategory;
import com.hollingsworth.arsnouveau.client.jei.MultiInputCategory;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.zeroregard.ars_technica.recipe.JeiArsExtraPlugin;
import com.zeroregard.ars_technica.recipe.TechnomancerArmorRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class TechnomancerUpgradeRecipeCategory
extends EnchantingApparatusRecipeCategory<TechnomancerArmorRecipe> {
    public TechnomancerUpgradeRecipeCategory(IGuiHelper helper) {
        super(helper);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TechnomancerArmorRecipe recipe, IFocusGroup focuses) {
        MultiInputCategory.MultiProvider provider = (MultiInputCategory.MultiProvider)this.multiProvider.apply(recipe);
        List inputs = provider.input();
        double angleBetweenEach = 360.0 / (double)inputs.size();
        if (provider.optionalCenter() != null) {
            ItemStack[] stacks = provider.optionalCenter().getItems();
            List<ItemStack> list = Arrays.stream(stacks).map(stack -> {
                ItemStack newStack = stack;
                ArmorPerkHolder armorPerkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
                if (armorPerkHolder != null) {
                    newStack = stack.copy();
                    newStack.set((Supplier)DataComponentRegistry.ARMOR_PERKS, (Object)armorPerkHolder.setTier(2));
                }
                return newStack;
            }).toList();
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 45).addItemStacks(list);
        }
        for (Ingredient input : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)this.point.x, (int)this.point.y).addIngredients(input);
            this.point = TechnomancerUpgradeRecipeCategory.rotatePointAbout((Vec2)this.point, (Vec2)this.center, (double)angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 10).addItemStacks(Collections.singletonList(provider.output()));
    }

    public Component getTitle() {
        return Component.translatable((String)"ars_nouveau.armor_upgrade");
    }

    public RecipeType<TechnomancerArmorRecipe> getRecipeType() {
        return JeiArsExtraPlugin.TECHNOMANCER_ARMOR_TYPE;
    }

    public void draw(TechnomancerArmorRecipe recipe, @NotNull IRecipeSlotsView slotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font renderer = Minecraft.getInstance().font;
        guiGraphics.drawString(renderer, (Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{3}), 0, 0, 10, false);
        if (recipe.consumesSource()) {
            guiGraphics.drawString(renderer, (Component)Component.translatable((String)"ars_nouveau.source", (Object[])new Object[]{recipe.sourceCost()}), 0, 100, 10, false);
        }
    }
}

