/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.item.ModonomiconItem;
import com.klikli_dev.modonomicon.networking.Message;
import com.klikli_dev.modonomicon.util.StreamCodecs;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BookClosedMessage
implements Message,
CustomPacketPayload {
    public static final CustomPacketPayload.Type<BookClosedMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"book_closed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BookClosedMessage> STREAM_CODEC = StreamCodec.composite(StreamCodecs.enumCodec(InteractionHand.class), m -> m.hand, BookClosedMessage::new);
    public InteractionHand hand;

    public BookClosedMessage(InteractionHand hand) {
        this.hand = hand;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        if (player == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(this.hand);
        if (ModonomiconItem.getBook(stack) != null) {
            ModonomiconItem.setBookClosed(stack);
        }
    }
}

