/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.content.jelly;

import com.hollingsworth.arsnouveau.api.spell.IContextAttachment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import dev.xkmc.arsdelight.init.ArsDelight;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record JellyAttachment(String jelly) implements IContextAttachment
{
    public static final ResourceLocation ID = ArsDelight.loc("jelly_context");

    public ResourceLocation id() {
        return ID;
    }

    @Nullable
    public PotionContents getData(Level level, SpellContext ctx) {
        ResourceLocation id = ResourceLocation.tryParse((String)this.jelly);
        if (id == null) {
            return null;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(id);
        FoodProperties food = item.getDefaultInstance().getFoodProperties(null);
        if (food == null) {
            return null;
        }
        ArrayList<MobEffectInstance> effs = new ArrayList<MobEffectInstance>();
        for (FoodProperties.PossibleEffect e : food.effects()) {
            if (!(e.probability() > level.getRandom().nextFloat())) continue;
            MobEffectInstance eff = e.effect();
            effs.add(new MobEffectInstance(eff.getEffect(), eff.getDuration() / 4, eff.getAmplifier()));
        }
        if (effs.isEmpty()) {
            return null;
        }
        return new PotionContents(Optional.empty(), Optional.empty(), effs);
    }
}

