/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.WeaponRegistry;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.DyeableVehicleEntity;
import immersive_aircraft.entity.inventory.SparseSimpleInventory;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.entity.misc.VehicleProperties;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.Telescope;
import immersive_aircraft.entity.weapon.Weapon;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import immersive_aircraft.mixin.ServerPlayerEntityMixin;
import immersive_aircraft.network.s2c.OpenGuiRequest;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class InventoryVehicleEntity
extends DyeableVehicleEntity
implements ContainerListener,
MenuProvider,
Container,
HasCustomInventoryScreen {
    private final VehicleProperties properties;
    private SparseSimpleInventory inventory;
    protected final Map<Integer, List<Weapon>> weapons = new HashMap<Integer, List<Weapon>>();
    private static final List<WeaponMount> EMPTY_WEAPONS = List.of(WeaponMount.EMPTY);
    private static final Map<WeaponMount.Type, List<WeaponMount>> EMPTY_WEAPONS_MAP = Map.of();

    public InventoryVehicleEntity(EntityType<? extends InventoryVehicleEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
        this.initInventory();
        this.properties = new VehicleProperties(this.getVehicleData().getProperties(), this);
    }

    public VehicleProperties getProperties() {
        return this.properties;
    }

    public VehicleInventoryDescription getInventoryDescription() {
        return this.getVehicleData().getInventoryDescription();
    }

    public List<WeaponMount> getWeaponMounts(int slot) {
        ItemStack stack = this.getSlot(slot).get();
        Item item = stack.getItem();
        if (item instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)item;
            return this.getVehicleData().getWeaponMounts().getOrDefault(slot, EMPTY_WEAPONS_MAP).getOrDefault((Object)weaponItem.getMountType(), EMPTY_WEAPONS);
        }
        return EMPTY_WEAPONS;
    }

    public List<ItemStack> getSlots(String slotType) {
        List<SlotDescription> slots = this.getInventoryDescription().getSlots(slotType);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(slots.size());
        for (SlotDescription slot : slots) {
            list.add(this.getInventory().getItem(slot.index()));
        }
        return list;
    }

    public float getTotalUpgrade(VehicleStat stat) {
        float value = 1.0f;
        List<ItemStack> upgrades = this.getSlots(VehicleInventoryDescription.UPGRADE);
        for (int step = 0; step < 2; ++step) {
            for (ItemStack stack : upgrades) {
                VehicleUpgrade upgrade = VehicleUpgradeRegistry.INSTANCE.getUpgrade(stack.getItem());
                if (upgrade == null) continue;
                float u = upgrade.get(stat);
                if (u > 0.0f && step == 1) {
                    value += u;
                    continue;
                }
                if (!(u < 0.0f) || step != 0) continue;
                value *= u + 1.0f;
            }
        }
        return Math.max(0.0f, value);
    }

    protected void initInventory() {
        this.inventory = new SparseSimpleInventory(this.getInventoryDescription().getInventorySize());
        this.inventory.addListener(this);
    }

    public SparseSimpleInventory getInventory() {
        int inventorySize = this.getInventoryDescription().getInventorySize();
        if (inventorySize != this.inventory.getContainerSize()) {
            this.initInventory();
        }
        return this.inventory;
    }

    public void containerChanged(Container sender) {
    }

    @Override
    protected void dropInventory() {
        for (SlotDescription slot : this.getInventoryDescription().getSlots()) {
            ItemStack stack;
            boolean isCargo = slot.type().equals(VehicleInventoryDescription.INVENTORY);
            if ((!isCargo || !Config.getInstance().dropInventory) && (isCargo || !Config.getInstance().dropUpgrades) || (stack = this.getSlot(slot.index()).get()).isEmpty()) continue;
            this.spawnAtLocation(stack.copyAndClear());
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new VehicleScreenHandler(i, playerInventory, this);
    }

    public void openInventory(ServerPlayer player) {
        ((ServerPlayerEntityMixin)player).ic$nextContainerCounter();
        AbstractContainerMenu screenHandler = this.createMenu(((ServerPlayerEntityMixin)player).getContainerCounter(), player.getInventory(), (Player)player);
        if (screenHandler != null) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(this, screenHandler.containerId), player);
            player.containerMenu = screenHandler;
            ServerPlayerEntityMixin playerAccessor = (ServerPlayerEntityMixin)player;
            screenHandler.setSynchronizer(playerAccessor.getContainerSynchronizer());
        }
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if ((double)this.getHealth() >= 1.0) {
            if (!player.level().isClientSide && player.isSecondaryUseActive() && !this.isPassengerOfSameVehicle((Entity)player)) {
                Entity primaryPassenger = this.getFirstPassenger();
                if (primaryPassenger != null) {
                    primaryPassenger.stopRiding();
                } else {
                    this.openInventory((ServerPlayer)player);
                }
                return InteractionResult.CONSUME;
            }
            if (this.getPassengerSpace() == 0 && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.openInventory(serverPlayer);
            }
        }
        return super.interact(player, hand);
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Inventory", (Tag)this.getInventory().createTag((HolderLookup.Provider)this.registryAccess()));
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag nbtList = tag.getList("Inventory", 10);
        this.getInventory().fromTag(nbtList, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public void addItemTag(ItemStack stack) {
        super.addItemTag(stack);
        stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.getInventory().getItems()));
    }

    @Override
    public void readItemTag(ItemStack stack) {
        super.readItemTag(stack);
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents != null) {
            contents.copyInto(this.getInventory().getItems());
        }
    }

    @Override
    public void boost() {
        int length = this.getSlots(VehicleInventoryDescription.BOOSTER).stream().mapToInt(s -> {
            Fireworks fireworks = (Fireworks)s.get(DataComponents.FIREWORKS);
            int l = fireworks == null ? 1 : fireworks.flightDuration();
            s.shrink(1);
            return l;
        }).sum();
        super.boost(length * 50);
    }

    @Override
    protected void applyBoost() {
        super.applyBoost();
        Vector3f direction = this.getForwardDirection();
        float thrust = 0.05f * (float)this.getBoost() / 100.0f;
        this.setDeltaMovement(this.getDeltaMovement().add(this.toVec3d(direction.mul(thrust))));
        if (this.tickCount % 2 == 0) {
            Vec3 p = this.position();
            Vec3 velocity = this.getDeltaMovement().subtract(this.toVec3d(direction));
            this.level().addParticle((ParticleOptions)ParticleTypes.FIREWORK, p.x(), p.y(), p.z(), velocity.x, velocity.y, velocity.z);
        }
    }

    @Override
    public boolean canBoost() {
        return this.getSlots(VehicleInventoryDescription.BOOSTER).stream().anyMatch(v -> !v.isEmpty()) && this.getBoost() <= 0;
    }

    @Override
    public void tick() {
        this.getInventory().tick(this);
        for (SlotDescription slot : this.getInventoryDescription().getSlots(VehicleInventoryDescription.WEAPON)) {
            WeaponRegistry.WeaponConstructor constructor;
            ItemStack weaponItemStack = this.getSlot(slot.index()).get();
            List<Weapon> weapon = this.weapons.get(slot.index());
            if (weaponItemStack.isEmpty() && weapon != null) {
                this.weapons.remove(slot.index());
                continue;
            }
            if (weaponItemStack.isEmpty() || weapon != null && weapon.get(0).getStack() == weaponItemStack || (constructor = WeaponRegistry.get(weaponItemStack)) == null) continue;
            List<WeaponMount> weaponMounts = this.getWeaponMounts(slot.index());
            ArrayList<Weapon> weapons = new ArrayList<Weapon>(weaponMounts.size());
            for (WeaponMount weaponMount : weaponMounts) {
                weapons.add(constructor.create(this, weaponItemStack, weaponMount, slot.index()));
            }
            this.weapons.put(slot.index(), weapons);
        }
        int gunnerOffset = this.getPassengers().size();
        for (List<Weapon> weapons : this.getWeapons().values()) {
            --gunnerOffset;
            for (Weapon weapon : weapons) {
                weapon.setGunnerOffset(Math.max(0, gunnerOffset));
            }
        }
        for (List<Weapon> weapons : this.weapons.values()) {
            for (Weapon w : weapons) {
                w.tick();
            }
        }
        super.tick();
    }

    protected float getGroundDecay() {
        return this.getProperties().get(VehicleStat.GROUND_FRICTION);
    }

    protected float getWaterDecay() {
        return this.getProperties().get(VehicleStat.WATER_FRICTION);
    }

    protected void applyFriction() {
        float decay = 1.0f - this.getProperties().get(VehicleStat.FRICTION);
        double gravity = this.getGravity();
        if (this.wasTouchingWater) {
            gravity *= 0.25;
            decay = this.getWaterDecay();
        } else if (this.onGround()) {
            decay = this.isVehicle() ? this.getGroundDecay() : 0.75f;
        }
        Vec3 velocity = this.getDeltaMovement();
        float hd = this.getProperties().get(VehicleStat.HORIZONTAL_DECAY);
        float vd = this.getProperties().get(VehicleStat.VERTICAL_DECAY);
        this.setDeltaMovement(velocity.x * (double)decay * (double)hd, velocity.y * (double)decay * (double)vd - gravity, velocity.z * (double)decay * (double)hd);
        float rf = decay * this.getProperties().get(VehicleStat.ROTATION_DECAY);
        this.pressingInterpolatedX.decay(0.0f, 1.0f - rf);
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - rf);
    }

    public SlotAccess getSlot(int slot) {
        return SlotAccess.forContainer((Container)this.getInventory(), (int)slot);
    }

    public Map<Integer, List<Weapon>> getWeapons() {
        return this.weapons;
    }

    @Override
    public float getDurability() {
        return this.getProperties().get(VehicleStat.DURABILITY);
    }

    public boolean isScoping() {
        Collection<List<Weapon>> values = this.getWeapons().values();
        for (List<Weapon> weapons : values) {
            for (Weapon weapon : weapons) {
                Telescope telescope;
                if (!(weapon instanceof Telescope) || !(telescope = (Telescope)weapon).isScoping().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.inventory.removeItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.inventory.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setItem(slot, stack);
    }

    public void setChanged() {
        this.inventory.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        SlotDescription slotType = this.getInventoryDescription().getSlots().get(index);
        Slot slot = slotType.getSlot(this, (Container)this.inventory);
        return slot.mayPlace(stack);
    }

    public boolean canTakeItem(Container target, int index, ItemStack stack) {
        SlotDescription slotType = this.getInventoryDescription().getSlots().get(index);
        return slotType.type().equals(VehicleInventoryDescription.INVENTORY);
    }

    public void clientFireWeapons(Entity entity) {
        int gunnerIndex = this.getPassengers().indexOf(entity);
        for (List<Weapon> weapons : this.getWeapons().values()) {
            int index = 0;
            for (Weapon weapon : weapons) {
                if (weapon.getGunnerOffset() != gunnerIndex) continue;
                weapon.clientFire(index++);
            }
        }
    }

    public void fireWeapon(int slot, int index, Vector3f direction) {
        this.getWeapons().get(slot).get(index).fire(direction);
    }

    public void openCustomInventoryScreen(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openInventory(serverPlayer);
        }
    }
}

