/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.util;

import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class LangUtil {
    private LangUtil() {
    }

    public static Set<String> getValidLanguages() {
        Minecraft client = Minecraft.getInstance();
        if (client != null) {
            return client.getLanguageManager().getLanguages().keySet();
        }
        return Set.of("en_us");
    }

    public static String getCurrentLanguage() {
        Minecraft client = Minecraft.getInstance();
        if (client != null) {
            return client.getLanguageManager().getSelected().toLowerCase(Locale.ROOT);
        }
        return "en_us";
    }

    public static ResourceLocation getTranslatedAsset(ResourceLocation assetId, String language) {
        return assetId.withPrefix("_" + language + "/");
    }

    public static ResourceLocation stripLangFromPageId(ResourceLocation pageId, Set<String> supportedLanguages) {
        String path = pageId.getPath();
        int firstSep = path.indexOf("/");
        if (firstSep == -1) {
            return pageId;
        }
        if (path.charAt(0) != '_') {
            return pageId;
        }
        if (firstSep + 1 >= path.length()) {
            return pageId;
        }
        String potentialLanguage = path.substring(1, firstSep);
        if (supportedLanguages.contains(potentialLanguage)) {
            return pageId.withPath(path.substring(firstSep + 1));
        }
        return pageId;
    }

    @Nullable
    public static String getLangFromPageId(ResourceLocation pageId, Set<String> supportedLanguages) {
        String path = pageId.getPath();
        int firstSep = path.indexOf("/");
        if (firstSep == -1) {
            return null;
        }
        if (path.charAt(0) != '_') {
            return null;
        }
        if (firstSep + 1 >= path.length()) {
            return null;
        }
        String potentialLanguage = path.substring(1, firstSep);
        if (supportedLanguages.contains(potentialLanguage)) {
            return potentialLanguage;
        }
        return null;
    }
}

