/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.geo;

import guideme.internal.shaded.lucene.geo.Component2D;
import guideme.internal.shaded.lucene.geo.Rectangle2D;
import guideme.internal.shaded.lucene.geo.XYEncodingUtils;
import guideme.internal.shaded.lucene.geo.XYGeometry;

public final class XYRectangle
extends XYGeometry {
    public final float minX;
    public final float maxX;
    public final float minY;
    public final float maxY;

    public XYRectangle(float minX, float maxX, float minY, float maxY) {
        if (minX > maxX) {
            throw new IllegalArgumentException("minX must be lower than maxX, got " + minX + " > " + maxX);
        }
        if (minY > maxY) {
            throw new IllegalArgumentException("minY must be lower than maxY, got " + minY + " > " + maxY);
        }
        this.minX = XYEncodingUtils.checkVal(minX);
        this.maxX = XYEncodingUtils.checkVal(maxX);
        this.minY = XYEncodingUtils.checkVal(minY);
        this.maxY = XYEncodingUtils.checkVal(maxY);
    }

    @Override
    protected Component2D toComponent2D() {
        return Rectangle2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XYRectangle rectangle = (XYRectangle)o;
        if (Float.compare(rectangle.minX, this.minX) != 0) {
            return false;
        }
        if (Float.compare(rectangle.minY, this.minY) != 0) {
            return false;
        }
        if (Float.compare(rectangle.maxX, this.maxX) != 0) {
            return false;
        }
        return Float.compare(rectangle.maxY, this.maxY) == 0;
    }

    public static XYRectangle fromPointDistance(float x, float y, float radius) {
        XYEncodingUtils.checkVal(x);
        XYEncodingUtils.checkVal(y);
        if (radius < 0.0f) {
            throw new IllegalArgumentException("radius must be bigger than 0, got " + radius);
        }
        if (!Float.isFinite(radius)) {
            throw new IllegalArgumentException("radius must be finite, got " + radius);
        }
        float distanceBox = Math.nextUp(radius);
        float minX = Math.max(-3.4028235E38f, x - distanceBox);
        float maxX = Math.min(Float.MAX_VALUE, x + distanceBox);
        float minY = Math.max(-3.4028235E38f, y - distanceBox);
        float maxY = Math.min(Float.MAX_VALUE, y + distanceBox);
        return new XYRectangle(minX, maxX, minY, maxY);
    }

    public int hashCode() {
        long temp = Float.floatToIntBits(this.minX);
        int result = (int)(temp ^ temp >>> 32);
        temp = Float.floatToIntBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Float.floatToIntBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Float.floatToIntBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("XYRectangle(x=");
        b.append(this.minX);
        b.append(" TO ");
        b.append(this.maxX);
        b.append(" y=");
        b.append(this.minY);
        b.append(" TO ");
        b.append(this.maxY);
        b.append(")");
        return b.toString();
    }
}

