/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityPoweredFurnace
extends TileEntityInventoryBase
implements IButtonReactor,
MenuProvider {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1 = 1;
    public static final int SLOT_INPUT_2 = 2;
    public static final int SLOT_OUTPUT_2 = 3;
    public static final int ENERGY_USE = 25;
    private static final int SMELT_TIME = 80;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 150, 0);
    public int firstSmeltTime;
    public int secondSmeltTime;
    public boolean isAutoSplit;
    private int lastEnergy;
    private int lastFirstSmelt;
    private int lastSecondSmelt;
    private boolean lastAutoSplit;
    private boolean lastSmelted;

    public TileEntityPoweredFurnace(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.POWERED_FURNACE.getTileEntityType(), pos, state, 4);
    }

    public static void autoSplit(ItemStackHandlerAA inv, int slot1, int slot2) {
        ItemStack first = inv.getStackInSlot(slot1);
        ItemStack second = inv.getStackInSlot(slot2);
        if (!first.isEmpty() || !second.isEmpty()) {
            ItemStack toSplit = ItemStack.EMPTY;
            if (first.isEmpty() && !second.isEmpty() && second.getCount() > 1) {
                toSplit = second;
            } else if (second.isEmpty() && !first.isEmpty() && first.getCount() > 1) {
                toSplit = first;
            } else if (!(!ItemUtil.canBeStacked(first, second) || first.getCount() >= first.getMaxStackSize() && second.getCount() >= second.getMaxStackSize() || first.getCount() <= second.getCount() + 1 && first.getCount() >= second.getCount() - 1 || second.getCount() <= first.getCount() + 1 && second.getCount() >= first.getCount() - 1)) {
                toSplit = first;
                toSplit.grow(second.getCount());
            }
            if (!toSplit.isEmpty()) {
                ItemStack splitFirst = toSplit.copy();
                ItemStack secondSplit = splitFirst.split(splitFirst.getCount() / 2);
                inv.setStackInSlot(slot1, splitFirst);
                inv.setStackInSlot(slot2, secondSplit);
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("FirstSmeltTime", this.firstSmeltTime);
            compound.putInt("SecondSmeltTime", this.secondSmeltTime);
            compound.putBoolean("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, lookupProvider, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstSmeltTime = compound.getInt("FirstSmeltTime");
            this.secondSmeltTime = compound.getInt("SecondSmeltTime");
            this.isAutoSplit = compound.getBoolean("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPoweredFurnace) {
            TileEntityPoweredFurnace tile = (TileEntityPoweredFurnace)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPoweredFurnace) {
            boolean current;
            TileEntityPoweredFurnace tile = (TileEntityPoweredFurnace)t;
            tile.serverTick();
            if (tile.isAutoSplit) {
                TileEntityPoweredFurnace.autoSplit(tile.inv, 0, 2);
            }
            boolean smelted = false;
            boolean canSmeltOnFirst = tile.canSmeltOn(0, 1);
            boolean canSmeltOnSecond = tile.canSmeltOn(2, 3);
            if (canSmeltOnFirst) {
                if (tile.storage.getEnergyStored() >= 25) {
                    ++tile.firstSmeltTime;
                    if (tile.firstSmeltTime >= 80) {
                        tile.finishBurning(0, 1);
                        tile.firstSmeltTime = 0;
                    }
                    tile.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                tile.firstSmeltTime = 0;
            }
            if (canSmeltOnSecond) {
                if (tile.storage.getEnergyStored() >= 25) {
                    ++tile.secondSmeltTime;
                    if (tile.secondSmeltTime >= 80) {
                        tile.finishBurning(2, 3);
                        tile.secondSmeltTime = 0;
                    }
                    tile.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                tile.secondSmeltTime = 0;
            }
            boolean changeTo = current = ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue();
            if (tile.lastSmelted != smelted) {
                changeTo = smelted;
            }
            if (tile.isRedstonePowered) {
                changeTo = true;
            }
            if (!smelted && !tile.isRedstonePowered) {
                changeTo = false;
            }
            if (changeTo != current) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(changeTo)), 3);
            }
            tile.lastSmelted = smelted;
            if ((tile.lastEnergy != tile.storage.getEnergyStored() || tile.lastFirstSmelt != tile.firstSmeltTime || tile.lastSecondSmelt != tile.secondSmeltTime || tile.isAutoSplit != tile.lastAutoSplit) && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
                tile.lastFirstSmelt = tile.firstSmeltTime;
                tile.lastAutoSplit = tile.isAutoSplit;
                tile.lastSecondSmelt = tile.secondSmeltTime;
            }
        }
    }

    public boolean validInput(ItemStack stack) {
        return this.getOutputForInput(stack).isPresent();
    }

    public Optional<ItemStack> getOutputForInput(ItemStack stack) {
        return this.level.getServer().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), this.level).map(recipe -> ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()));
    }

    public Optional<RecipeHolder<SmeltingRecipe>> getRecipeForInput(ItemStack stack) {
        return this.level.getServer().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), this.level);
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || (slot == 0 || slot == 2) && this.validInput(stack);
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1 || slot == 3;
    }

    public boolean canSmeltOn(int theInput, int theOutput) {
        ItemStack input = this.inv.getStackInSlot(theInput);
        ItemStack output = this.inv.getStackInSlot(theOutput);
        if (!input.isEmpty()) {
            Optional<RecipeHolder<SmeltingRecipe>> recipe = this.getRecipeForInput(input);
            return recipe.map($ -> output.isEmpty() || ItemStack.isSameItem((ItemStack)output, (ItemStack)((SmeltingRecipe)$.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess())) && output.getCount() <= output.getMaxStackSize() - ((SmeltingRecipe)$.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()).orElse(false);
        }
        return false;
    }

    public void finishBurning(int theInput, int theOutput) {
        ItemStack output = this.getOutputForInput(this.inv.getStackInSlot(theInput)).orElse(ItemStack.EMPTY);
        if (this.inv.getStackInSlot(theOutput).isEmpty()) {
            this.inv.setStackInSlot(theOutput, output.copy());
        } else if (this.inv.getStackInSlot(theOutput).getItem() == output.getItem()) {
            this.inv.getStackInSlot(theOutput).grow(output.getCount());
        }
        this.inv.getStackInSlot(theInput).shrink(1);
    }

    public int getFirstTimeToScale(int i) {
        return this.firstSmeltTime * i / 80;
    }

    public int getSecondTimeToScale(int i) {
        return this.secondSmeltTime * i / 80;
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.setChanged();
        }
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.powered_furnace");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new ContainerFurnaceDouble(windowId, playerInventory, this);
    }

    protected void applyImplicitComponents(@Nonnull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.storage.setEnergyStored((Integer)input.getOrDefault(ActuallyComponents.ENERGY_STORAGE, (Object)0));
    }

    protected void collectImplicitComponents(@Nonnull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ActuallyComponents.ENERGY_STORAGE, (Object)this.storage.getEnergyStored());
    }
}

