/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.lens;

import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.mod.crafting.ColorChangeRecipe;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LensColor
extends Lens {
    public static final int ENERGY_USE = 200;
    public static final int[] POSSIBLE_COLORS = new int[]{10365735, 15367733, 12760092, 3783214, 3558168, 6522834, 2519441, 2437779, 8271039, 12470729, 14254489, 5649180};
    private final Random rand = new Random();

    @Override
    public boolean invoke(BlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        if (hitBlock != null) {
            BlockState state;
            Block block;
            ItemStack returnStack;
            if (tile.getEnergy() >= 200 && !(returnStack = this.tryConvert(new ItemStack((ItemLike)(block = (state = tile.getWorldObject().getBlockState(hitBlock)).getBlock())), (HolderLookup.Provider)tile.getWorldObject().registryAccess())).isEmpty() && returnStack.getItem() instanceof BlockItem) {
                Block toPlace = Block.byItem((Item)returnStack.getItem());
                BlockState state2Place = toPlace.defaultBlockState();
                tile.getWorldObject().setBlock(hitBlock, state2Place, 2);
                tile.extractEnergy(200);
            }
            List items = tile.getWorldObject().getEntitiesOfClass(ItemEntity.class, new AABB((double)hitBlock.getX(), (double)hitBlock.getY(), (double)hitBlock.getZ(), (double)(hitBlock.getX() + 1), (double)(hitBlock.getY() + 1), (double)(hitBlock.getZ() + 1)));
            for (ItemEntity item : items) {
                ItemStack newStack;
                if (!item.isAlive() || item.getItem().isEmpty() || tile.getEnergy() < 200 || (newStack = this.tryConvert(item.getItem(), (HolderLookup.Provider)tile.getWorldObject().registryAccess())).isEmpty()) continue;
                item.discard();
                ItemEntity newItem = new ItemEntity(tile.getWorldObject(), item.getX(), item.getY(), item.getZ(), newStack);
                tile.getWorldObject().addFreshEntity((Entity)newItem);
                tile.extractEnergy(200);
            }
        }
        return false;
    }

    private ItemStack tryConvert(ItemStack stack, HolderLookup.Provider registries) {
        ItemStack newStack = ColorChangeRecipe.getRecipeForStack(stack).map(recipe -> ((ColorChangeRecipe)recipe.value()).getResultItem(registries)).orElse(ItemStack.EMPTY);
        newStack.setCount(stack.getCount());
        return newStack;
    }

    @Override
    public int getColor() {
        return POSSIBLE_COLORS[this.rand.nextInt(POSSIBLE_COLORS.length)];
    }

    @Override
    public int getDistance() {
        return 10;
    }

    @Override
    public boolean canInvoke(IAtomicReconstructor tile, Direction sideToShootTo, int energyUsePerShot) {
        return tile.getEnergy() - energyUsePerShot >= 200;
    }
}

