/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotOutput;
import de.ellpeck.actuallyadditions.mod.items.ItemSolidifiedExperience;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityXPSolidifier;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerXPSolidifier
extends AbstractContainerMenu {
    public final TileEntityXPSolidifier solidifier;

    public static ContainerXPSolidifier fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerXPSolidifier(windowId, inv, (TileEntityXPSolidifier)Objects.requireNonNull(inv.player.level().getBlockEntity(data.readBlockPos())));
    }

    public ContainerXPSolidifier(int windowId, Inventory inventory, TileEntityXPSolidifier tile) {
        super(ActuallyContainers.XPSOLIDIFIER_CONTAINER.get(), windowId);
        int i;
        this.solidifier = tile;
        this.addSlot((Slot)new SlotOutput(this.solidifier.inv, 0, 95, 8));
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.solidifier.inv, 1, 65, 8));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 97 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 155));
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slot) {
        int inventoryStart = 2;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot >= inventoryStart ? (newStack.getItem() instanceof ItemSolidifiedExperience ? !this.moveItemStackTo(newStack, 1, 2, false) : (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false))) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.solidifier.canPlayerUse(player);
    }
}

