/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.SeatBlock;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.block.properties.SofaType;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends SeatBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<SofaType> TYPE = ModBlockStateProperties.SOFA_TYPE;
    public static final VoxelShape SEAT_BASE = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_SINGLE = Block.box((double)2.0, (double)7.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_MIDDLE = Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_LEFT = Block.box((double)0.0, (double)7.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_RIGHT = Block.box((double)2.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LEG_BL = Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0);
    public static final VoxelShape LEG_BR = Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0);
    public static final VoxelShape LEG_FR = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0);
    public static final VoxelShape LEG_FL = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0);
    public static final VoxelShape ARM_L = Block.box((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape ARM_R = Block.box((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0);
    public static final VoxelShape SINGLE = Shapes.or((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_SINGLE, ARM_L, ARM_R, LEG_BL, LEG_BR, LEG_FL, LEG_FR});
    public static final VoxelShape SINGLE_EAST = ShapeUtil.rotateShape(SINGLE, Direction.EAST);
    public static final VoxelShape SINGLE_SOUTH = ShapeUtil.rotateShape(SINGLE, Direction.SOUTH);
    public static final VoxelShape SINGLE_WEST = ShapeUtil.rotateShape(SINGLE, Direction.WEST);
    public static final VoxelShape MIDDLE = Shapes.or((VoxelShape)SEAT_BASE, (VoxelShape)SEAT_BACK_MIDDLE);
    public static final VoxelShape MIDDLE_EAST = ShapeUtil.rotateShape(MIDDLE, Direction.EAST);
    public static final VoxelShape MIDDLE_SOUTH = ShapeUtil.rotateShape(MIDDLE, Direction.SOUTH);
    public static final VoxelShape MIDDLE_WEST = ShapeUtil.rotateShape(MIDDLE, Direction.WEST);
    public static final VoxelShape OUTER = Shapes.or((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{LEG_BL, LEG_FR, Block.box((double)12.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final VoxelShape OUTER_EAST = ShapeUtil.rotateShape(OUTER, Direction.EAST);
    public static final VoxelShape OUTER_SOUTH = ShapeUtil.rotateShape(OUTER, Direction.SOUTH);
    public static final VoxelShape OUTER_WEST = ShapeUtil.rotateShape(OUTER, Direction.WEST);
    public static final VoxelShape INNER = Shapes.or((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_MIDDLE, LEG_BL, LEG_FR, Block.box((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0)});
    public static final VoxelShape INNER_EAST = ShapeUtil.rotateShape(INNER, Direction.EAST);
    public static final VoxelShape INNER_SOUTH = ShapeUtil.rotateShape(INNER, Direction.SOUTH);
    public static final VoxelShape INNER_WEST = ShapeUtil.rotateShape(INNER, Direction.WEST);
    public static final VoxelShape RIGHT = Shapes.or((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_RIGHT, ARM_R, LEG_BR, LEG_FR});
    public static final VoxelShape RIGHT_EAST = ShapeUtil.rotateShape(RIGHT, Direction.EAST);
    public static final VoxelShape RIGHT_SOUTH = ShapeUtil.rotateShape(RIGHT, Direction.SOUTH);
    public static final VoxelShape RIGHT_WEST = ShapeUtil.rotateShape(RIGHT, Direction.WEST);
    public static final VoxelShape LEFT = Shapes.or((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_LEFT, ARM_L, LEG_BL, LEG_FL});
    public static final VoxelShape LEFT_EAST = ShapeUtil.rotateShape(LEFT, Direction.EAST);
    public static final VoxelShape LEFT_SOUTH = ShapeUtil.rotateShape(LEFT, Direction.SOUTH);
    public static final VoxelShape LEFT_WEST = ShapeUtil.rotateShape(LEFT, Direction.WEST);

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.35f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        Direction facingRelative;
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState stateRelative = level.getBlockState(pos.relative(facing));
        if (stateRelative.getBlock() instanceof SofaBlock && facing != (facingRelative = (Direction)stateRelative.getValue((Property)FACING))) {
            return pos.relative(facing).relative(facingRelative);
        }
        return pos.relative(facing);
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        float corner = switch ((SofaType)((Object)state.getValue(TYPE))) {
            case SofaType.INNER_LEFT, SofaType.OUTER_LEFT -> -45.0f;
            case SofaType.INNER_RIGHT, SofaType.OUTER_RIGHT -> 45.0f;
            default -> 0.0f;
        };
        return ((Direction)state.getValue((Property)FACING)).toYRot() + corner;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return (BlockState)blockState.setValue(TYPE, (Comparable)((Object)SofaBlock.getConnection(blockState, context.getLevel(), blockPos)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue(TYPE, (Comparable)((Object)SofaBlock.getConnection(state, (Level)level, currentPos))) : super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        SofaType shape = (SofaType)((Object)state.getValue(TYPE));
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case SofaType.SINGLE -> {
                switch (facing) {
                    case EAST: {
                        yield SINGLE_EAST;
                    }
                    case SOUTH: {
                        yield SINGLE_SOUTH;
                    }
                    case WEST: {
                        yield SINGLE_WEST;
                    }
                }
                yield SINGLE;
            }
            case SofaType.MIDDLE -> {
                switch (facing) {
                    case EAST: {
                        yield MIDDLE_EAST;
                    }
                    case SOUTH: {
                        yield MIDDLE_SOUTH;
                    }
                    case WEST: {
                        yield MIDDLE_WEST;
                    }
                }
                yield MIDDLE;
            }
            case SofaType.OUTER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_EAST;
                    }
                    case SOUTH: {
                        yield OUTER_SOUTH;
                    }
                    case WEST: {
                        yield OUTER_WEST;
                    }
                }
                yield OUTER;
            }
            case SofaType.OUTER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_SOUTH;
                    }
                    case SOUTH: {
                        yield OUTER_WEST;
                    }
                    case WEST: {
                        yield OUTER;
                    }
                }
                yield OUTER_EAST;
            }
            case SofaType.LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield LEFT_EAST;
                    }
                    case SOUTH: {
                        yield LEFT_SOUTH;
                    }
                    case WEST: {
                        yield LEFT_WEST;
                    }
                }
                yield LEFT;
            }
            case SofaType.RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield RIGHT_SOUTH;
                    }
                    case WEST: {
                        yield RIGHT_WEST;
                    }
                }
                yield RIGHT;
            }
            case SofaType.INNER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_SOUTH;
                    }
                    case SOUTH: {
                        yield INNER_WEST;
                    }
                    case WEST: {
                        yield INNER;
                    }
                }
                yield INNER_EAST;
            }
            case SofaType.INNER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_EAST;
                    }
                    case SOUTH: {
                        yield INNER_SOUTH;
                    }
                    case WEST: {
                        yield INNER_WEST;
                    }
                }
                yield INNER;
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public static SofaType getConnection(BlockState state, Level level, BlockPos pos) {
        Direction dir2;
        Direction dir1;
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState state1 = level.getBlockState(pos.relative(facing));
        if (state1.getBlock() instanceof SofaBlock && (dir1 = (Direction)state1.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && SofaBlock.isDifferentOrientation(state, level, pos, dir1.getOpposite())) {
            if (dir1 == facing.getCounterClockWise()) {
                return SofaType.INNER_LEFT;
            }
            return SofaType.INNER_RIGHT;
        }
        BlockState state2 = level.getBlockState(pos.relative(facing.getOpposite()));
        if (state2.getBlock() instanceof SofaBlock && (dir2 = (Direction)state2.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && SofaBlock.isDifferentOrientation(state, level, pos, dir2)) {
            if (dir2 == facing.getCounterClockWise()) {
                return SofaType.OUTER_LEFT;
            }
            return SofaType.OUTER_RIGHT;
        }
        boolean left = SofaBlock.canConnect(level, pos, ((Direction)state.getValue((Property)FACING)).getCounterClockWise());
        boolean right = SofaBlock.canConnect(level, pos, ((Direction)state.getValue((Property)FACING)).getClockWise());
        if (left && right) {
            return SofaType.MIDDLE;
        }
        if (left) {
            return SofaType.LEFT;
        }
        if (right) {
            return SofaType.RIGHT;
        }
        return SofaType.SINGLE;
    }

    public static boolean canConnect(Level level, BlockPos pos, Direction direction) {
        BlockState state = level.getBlockState(pos.relative(direction));
        return state.getBlock() instanceof SofaBlock;
    }

    public static boolean isDifferentOrientation(BlockState state, Level level, BlockPos pos, Direction dir) {
        BlockState blockState = level.getBlockState(pos.relative(dir));
        return !(blockState.getBlock() instanceof SofaBlock) || blockState.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        SofaType type = (SofaType)((Object)state.getValue(TYPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (type) {
                    case SofaType.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_RIGHT));
                    case SofaType.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_LEFT));
                    case SofaType.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_RIGHT));
                    case SofaType.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_LEFT));
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (type) {
                    case SofaType.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_LEFT));
                    case SofaType.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_RIGHT));
                    case SofaType.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_RIGHT));
                    case SofaType.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_LEFT));
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }
}

