/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Operation;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.ContainerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.PlayerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.MatchTransferButton;
import dev.terminalmc.clientsort.client.gui.widget.SortButton;
import dev.terminalmc.clientsort.client.gui.widget.StackFillButton;
import dev.terminalmc.clientsort.client.gui.widget.TransferButton;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.client.inventory.Scope;
import dev.terminalmc.clientsort.client.inventory.helper.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.util.KeybindManager;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.mixin.client.accessor.ScreenAccessor;
import dev.terminalmc.clientsort.util.Localization;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class TriggerButtonManager {
    private static final int BUTTON_SPACING = 1;
    private static final int BUTTON_SHIFT_X = 0;
    private static final int BUTTON_SHIFT_Y = 1;
    @Nullable
    private static AbstractContainerScreen<?> screen;
    private static final LinkedHashSet<TriggerButton> containerButtons;
    private static final LinkedHashSet<TriggerButton> visibleContainerButtons;
    private static final LinkedHashSet<TriggerButton> playerButtons;
    private static final LinkedHashSet<TriggerButton> visiblePlayerButtons;

    private TriggerButtonManager() {
    }

    @Nullable
    public static AbstractContainerScreen<?> getScreen() {
        return screen;
    }

    public static LinkedList<TriggerButton> getContainerButtons() {
        return new LinkedList<TriggerButton>(containerButtons);
    }

    public static LinkedList<TriggerButton> getPlayerButtons() {
        return new LinkedList<TriggerButton>(playerButtons);
    }

    @Nullable
    public static Slot getContainerRefSlot(Operation op) {
        return TriggerButtonManager.getRefSlot(containerButtons, op);
    }

    @Nullable
    public static Slot getPlayerRefSlot(Operation op) {
        return TriggerButtonManager.getRefSlot(playerButtons, op);
    }

    @Nullable
    private static Slot getRefSlot(LinkedHashSet<TriggerButton> buttons, Operation op) {
        Class clazz = switch (op) {
            default -> throw new MatchException(null, null);
            case Operation.SORT -> SortButton.class;
            case Operation.STACK_FILL -> StackFillButton.class;
            case Operation.MATCH_TRANSFER -> MatchTransferButton.class;
            case Operation.TRANSFER -> TransferButton.class;
        };
        for (TriggerButton button : buttons) {
            if (!((Object)((Object)button)).getClass().equals(clazz)) continue;
            return button.referenceSlot;
        }
        return null;
    }

    public static void afterScreenInit(Screen initScreen) {
        Slot refSlotP;
        if (!(initScreen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen acs = (AbstractContainerScreen)initScreen;
        if (screen != null) {
            TriggerButtonManager.getContainerButtons().forEach(b -> ((ScreenAccessor)screen).clientsort$removeWidget((GuiEventListener)b));
            TriggerButtonManager.getPlayerButtons().forEach(b -> ((ScreenAccessor)screen).clientsort$removeWidget((GuiEventListener)b));
        }
        containerButtons.clear();
        visibleContainerButtons.clear();
        playerButtons.clear();
        visiblePlayerButtons.clear();
        screen = acs;
        boolean enabled = Config.options().showButtons;
        boolean isEditorC = false;
        boolean isEditorP = false;
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen instanceof SelectorScreen) {
            isEditorC = true;
            isEditorP = true;
        } else if (currentScreen instanceof ContainerEditorScreen) {
            isEditorC = true;
        } else if (currentScreen instanceof PlayerEditorScreen) {
            isEditorP = true;
        }
        Slot refSlotC = TriggerButtonManager.getReferenceSlot(acs, false);
        if (refSlotC != null) {
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().thirdButtonOp);
            TriggerButtonManager.generate(acs, refSlotC, false, isEditorC, enabled, Config.options().fourthButtonOp);
        }
        if ((refSlotP = TriggerButtonManager.getReferenceSlot(acs, true)) != null) {
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().thirdButtonOp);
            TriggerButtonManager.generate(acs, refSlotP, true, isEditorP, enabled, Config.options().fourthButtonOp);
        }
    }

    private static void generate(AbstractContainerScreen<?> screen, Slot refSlot, boolean isPlayerInv, boolean isEditor, boolean enabled, Operation op) {
        switch (op) {
            case SORT: {
                TriggerButtonManager.generateSimpleButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canSort, ClassPolicy::showSortButton, ClassPolicy::autoSort, SortButton::new, (Component)Localization.localized("key", "op.sort", new Object[0]));
                break;
            }
            case STACK_FILL: {
                TriggerButtonManager.generateDirectionalButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canStackFill, ClassPolicy::showStackFillButton, ClassPolicy::autoStackFill, StackFillButton::new, (Component)Localization.localized("key", "op.stackFill", new Object[0]));
                break;
            }
            case MATCH_TRANSFER: {
                TriggerButtonManager.generateDirectionalButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canMatchTransfer, ClassPolicy::showMatchTransferButton, ClassPolicy::autoMatchTransfer, MatchTransferButton::new, (Component)Localization.localized("key", "op.matchTransfer", new Object[0]));
                break;
            }
            case TRANSFER: {
                TriggerButtonManager.generateDirectionalButton(screen, refSlot, isPlayerInv, isEditor, enabled, ClassPolicy::canTransfer, ClassPolicy::showTransferButton, ClassPolicy::autoTransfer, TransferButton::new, (Component)Localization.localized("key", "op.transfer", new Object[0]));
            }
        }
    }

    private static void generateSimpleButton(AbstractContainerScreen<?> screen, Slot referenceSlot, boolean isPlayerInv, boolean isEditor, boolean enabled, Function<ClassPolicy, Boolean> opCheck, Function<ClassPolicy, Boolean> buttonCheck, Function<ClassPolicy, Boolean> autoCheck, TriggerButtonCreator creator, Component name) {
        Vec2i offset;
        boolean add;
        boolean autoPress = false;
        @Nullable LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (screen instanceof InventoryScreen && !isPlayerInv) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.getInventory() : TriggerButtonManager.getContainer((Player)player);
        Object object = dev.terminalmc.clientsort.ClientSort.getObj((Container)container, screen.getMenu());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        boolean create = isEditor || policy == null || opCheck.apply(policy) != false;
        boolean bl = add = enabled && (isEditor || policy != null && buttonCheck.apply(policy) != false);
        if (!create) {
            return;
        }
        Vec2i vec2i = offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        if (policy != null && autoCheck.apply(policy).booleanValue()) {
            autoPress = true;
        }
        TriggerButton button = creator.create(screen, (Container)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), name);
        (isPlayerInv ? playerButtons : containerButtons).add(button);
        if (add) {
            (isPlayerInv ? visiblePlayerButtons : visibleContainerButtons).add(button);
            ((ScreenAccessor)screen).clientsort$addRenderableWidget(button);
        }
        if (autoPress) {
            ClientSort.taskManager.schedule(isPlayerInv ? Config.options().autoOpDelayPlayer : Config.options().autoOpDelayContainer, () -> {
                if (Minecraft.getInstance().screen == screen && !KeybindManager.isDown(KeybindManager.CANCEL_AUTO_KEY) && (isPlayerInv ? playerButtons : containerButtons).contains((Object)button)) {
                    button.onPress();
                }
            });
        }
    }

    private static void generateDirectionalButton(AbstractContainerScreen<?> screen, Slot referenceSlot, boolean isPlayerInv, boolean isEditor, boolean enabled, Function<ClassPolicy, Boolean> opCheck, Function<ClassPolicy, Boolean> buttonCheck, Function<ClassPolicy, Boolean> autoCheck, TriggerButtonCreator creator, Component name) {
        Container dstContainer;
        Vec2i offset;
        boolean add;
        boolean autoPress = false;
        @Nullable LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (screen instanceof InventoryScreen && !isPlayerInv) {
            return;
        }
        @Nullable Object container = isPlayerInv ? player.getInventory() : TriggerButtonManager.getContainer((Player)player);
        Object object = dev.terminalmc.clientsort.ClientSort.getObj((Container)container, screen.getMenu());
        if (object == null) {
            return;
        }
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
        boolean create = isEditor || policy == null || opCheck.apply(policy) != false;
        boolean bl = add = enabled && (isEditor || policy != null && buttonCheck.apply(policy) != false);
        if (!create) {
            return;
        }
        Vec2i vec2i = offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        if (policy != null && autoCheck.apply(policy).booleanValue() && !policy.autoOpOther()) {
            autoPress = true;
        }
        Object object2 = dstContainer = isPlayerInv ? TriggerButtonManager.getContainer((Player)player) : player.getInventory();
        if (dstContainer != null) {
            Object dstObject = dev.terminalmc.clientsort.ClientSort.getObj(dstContainer, screen.getMenu());
            if (dstObject == null) {
                return;
            }
            @Nullable ClassPolicy dstPolicy = PolicyManager.getPolicy(dstObject.getClass());
            create = isEditor || dstPolicy == null || opCheck.apply(dstPolicy) != false;
            boolean bl2 = add = add && (isEditor || dstPolicy != null && buttonCheck.apply(dstPolicy) != false);
            if (!create) {
                return;
            }
            if (dstPolicy != null && autoCheck.apply(dstPolicy).booleanValue() && dstPolicy.autoOpOther()) {
                autoPress = true;
            }
        }
        TriggerButton button = creator.create(screen, (Container)container, referenceSlot, isPlayerInv, policy, object.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv), name);
        (isPlayerInv ? playerButtons : containerButtons).add(button);
        if (add) {
            (isPlayerInv ? visiblePlayerButtons : visibleContainerButtons).add(button);
            ((ScreenAccessor)screen).clientsort$addRenderableWidget(button);
        }
        if (autoPress) {
            ClientSort.taskManager.schedule(isPlayerInv ? Config.options().autoOpDelayPlayer : Config.options().autoOpDelayContainer, () -> {
                if (Minecraft.getInstance().screen == screen && !KeybindManager.isDown(KeybindManager.CANCEL_AUTO_KEY) && (isPlayerInv ? playerButtons : containerButtons).contains((Object)button)) {
                    button.onPress();
                }
            });
        }
    }

    @Nullable
    public static Container getContainer(Player player) {
        class ScoredContainer {
            public final Container container;
            public int score;

            public ScoredContainer(Container container, int score) {
                this.container = container;
                this.score = score;
            }
        }
        HashMap<Container, ScoredContainer> map = new HashMap<Container, ScoredContainer>();
        for (Slot slot : player.containerMenu.slots) {
            if (slot.container == null) continue;
            if (slot.container == player.getInventory() || slot.container instanceof Inventory) break;
            @Nullable TriggerButtonManager.1ScoredContainer scoredContainer = (ScoredContainer)map.get(slot.container);
            if (scoredContainer == null) {
                map.put(slot.container, new ScoredContainer(slot.container, 1));
                continue;
            }
            ++scoredContainer.score;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map.values().stream().max(Comparator.comparingInt((ToIntFunction<ScoredContainer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$getContainer$4(dev.terminalmc.clientsort.client.gui.TriggerButtonManager$1ScoredContainer ), (Ldev/terminalmc/clientsort/client/gui/TriggerButtonManager$1ScoredContainer;)I)())).get().container;
    }

    @Nullable
    private static Slot getReferenceSlot(AbstractContainerScreen<?> screen, boolean isPlayerInv) {
        ContainerScreenHelper<AbstractContainerScreen<?>> helper = ContainerScreenHelper.of(screen);
        Slot bestSlot = null;
        double bestScore = 0.0;
        Scope scope = isPlayerInv ? Scope.PLAYER_INV : Scope.CONTAINER_INV;
        for (Slot slot : helper.getLargestSlotGroup(scope)) {
            double y;
            double x = (double)Math.clamp((long)slot.x, 0, screen.width) / (double)screen.width;
            double score = x * 0.8 + (y = (double)(screen.height - Math.clamp((long)slot.y, 0, screen.height)) / (double)screen.height) * 0.2;
            if (!(score > bestScore)) continue;
            bestSlot = slot;
            bestScore = score;
        }
        return bestSlot;
    }

    public static Vec2i getShiftedOffset(Vec2i offset, boolean isPlayerInv) {
        int index = (isPlayerInv ? visiblePlayerButtons : visibleContainerButtons).size();
        int x = offset.x() + 0 * index;
        int y = offset.y() + 14 * index;
        return new Vec2i(x, y);
    }

    private static /* synthetic */ int lambda$getContainer$4(1ScoredContainer s) {
        return s.score;
    }

    static {
        containerButtons = new LinkedHashSet();
        visibleContainerButtons = new LinkedHashSet();
        playerButtons = new LinkedHashSet();
        visiblePlayerButtons = new LinkedHashSet();
    }

    @FunctionalInterface
    public static interface TriggerButtonCreator {
        public TriggerButton create(AbstractContainerScreen<?> var1, Container var2, Slot var3, boolean var4, @Nullable ClassPolicy var5, String var6, Vec2i var7, Component var8);
    }
}

