/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.renderer.item.FishingRodRenderer;
import com.hollingsworth.arsnouveau.common.entity.EnchantedHook;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnchantersFishingRod
extends ModItem
implements ICasterTool,
GeoItem {
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EnchantersFishingRod() {
        super(new Item.Properties().stacksTo(1).component(DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster()));
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.fishing != null) {
            if (!level.isClientSide) {
                FishingHook fishingHook;
                Entity hookedIn = player.fishing.getHookedIn();
                if (hookedIn != null && (fishingHook = player.fishing) instanceof EnchantedHook) {
                    EnchantedHook enchantedHook = (EnchantedHook)fishingHook;
                    enchantedHook.castSpell();
                } else {
                    int i = player.fishing.retrieve(itemstack);
                    ItemStack original = itemstack.copy();
                    itemstack.hurtAndBreak(i, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    if (itemstack.isEmpty()) {
                        EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)original, (InteractionHand)hand);
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                    player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                }
            }
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                int j = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverlevel, (ItemStack)itemstack, (Entity)player) * 20.0f);
                int k = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverlevel, (ItemStack)itemstack, (Entity)player);
                ItemStack stack = player.getItemInHand(hand);
                AbstractCaster caster = this.getSpellCaster(stack);
                Spell spell = caster.modifySpellBeforeCasting(serverlevel, (Entity)player, hand, caster.getSpell());
                if (!spell.isValid()) {
                    PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.fishing_rod.invalid"));
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
                }
                PlayerCaster wrappedCaster = new PlayerCaster(player);
                level.addFreshEntity((Entity)new EnchantedHook(player, level, k, j, new SpellContext(level, spell, (LivingEntity)player, wrappedCaster)));
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_FISHING_ROD_ACTIONS.contains(itemAbility);
    }

    @Override
    public boolean isScribedSpellValid(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.mutable().recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    @Override
    public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.fishing_rod.invalid"));
    }

    @Override
    public void scribeModifiedSpell(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell.Mutable spell) {
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        recipe.add(MethodTouch.INSTANCE);
        recipe.addAll(spell.recipe);
        spell.recipe = recipe;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        if (Screen.hasShiftDown() || !((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue()) {
            this.getInformation(stack, context, tooltip2, flagIn);
        }
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        if (caster != null && ((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !Screen.hasShiftDown() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            final FishingRodRenderer renderer = new FishingRodRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }
}

