/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerData;
import com.hollingsworth.arsnouveau.common.capability.FamiliarData;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSyncPlayerCap;
import com.hollingsworth.arsnouveau.setup.registry.AttachmentsRegistry;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ANPlayerDataCap
implements IPlayerCap {
    private ANPlayerData playerData;
    LivingEntity entity;

    public ANPlayerDataCap(LivingEntity livingEntity) {
        this.playerData = (ANPlayerData)livingEntity.getData(AttachmentsRegistry.PLAYER_DATA);
        this.entity = livingEntity;
    }

    @Override
    public Collection<AbstractSpellPart> getKnownGlyphs() {
        return this.playerData.glyphs;
    }

    @Override
    public void setKnownGlyphs(Collection<AbstractSpellPart> glyphs) {
        this.playerData.glyphs = new HashSet<AbstractSpellPart>(glyphs);
        this.entity.setData(AttachmentsRegistry.PLAYER_DATA, (Object)this.playerData);
    }

    @Override
    public boolean unlockGlyph(AbstractSpellPart spellPart) {
        boolean result = this.playerData.glyphs.add(spellPart);
        if (result) {
            this.entity.setData(AttachmentsRegistry.PLAYER_DATA, (Object)this.playerData);
        }
        return result;
    }

    @Override
    public boolean knowsGlyph(AbstractSpellPart spellPart) {
        return this.playerData.glyphs.contains(spellPart);
    }

    @Override
    public boolean unlockFamiliar(AbstractFamiliarHolder holderID) {
        boolean result = this.playerData.familiars.add(new FamiliarData(holderID.getRegistryName()));
        if (result) {
            this.entity.setData(AttachmentsRegistry.PLAYER_DATA, (Object)this.playerData);
        }
        return result;
    }

    @Override
    public boolean ownsFamiliar(AbstractFamiliarHolder holderID) {
        return this.playerData.familiars.stream().anyMatch(f -> f.familiarHolder.getRegistryName().equals((Object)holderID.getRegistryName()));
    }

    @Override
    public Collection<FamiliarData> getUnlockedFamiliars() {
        return this.playerData.familiars;
    }

    @Override
    @Nullable
    public FamiliarData getFamiliarData(ResourceLocation id) {
        return this.playerData.familiars.stream().filter(f -> f.familiarHolder.getRegistryName().equals((Object)id)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public FamiliarData getLastSummonedFamiliar() {
        return this.playerData.lastSummonedFamiliar == null ? null : this.getFamiliarData(this.playerData.lastSummonedFamiliar);
    }

    @Override
    public void setLastSummonedFamiliar(ResourceLocation lastSummonedFamiliar) {
        this.playerData.lastSummonedFamiliar = lastSummonedFamiliar;
        this.entity.setData(AttachmentsRegistry.PLAYER_DATA, (Object)this.playerData);
    }

    @Override
    public void setUnlockedFamiliars(Collection<FamiliarData> familiars) {
        this.playerData.familiars = new HashSet<FamiliarData>(familiars);
        this.entity.setData(AttachmentsRegistry.PLAYER_DATA, (Object)this.playerData);
    }

    @Override
    public boolean removeFamiliar(AbstractFamiliarHolder holderID) {
        boolean result = this.playerData.familiars.removeIf(f -> f.familiarHolder.getRegistryName().equals((Object)holderID.getRegistryName()));
        if (result) {
            this.entity.setData(AttachmentsRegistry.PLAYER_DATA, (Object)this.playerData);
        }
        return result;
    }

    public void setPlayerData(ANPlayerData data) {
        this.playerData = data;
    }

    public void syncToClient(ServerPlayer player) {
        CompoundTag tag = this.playerData.serializeNBT((HolderLookup.Provider)player.registryAccess());
        Networking.sendToPlayerClient(new PacketSyncPlayerCap(tag), player);
    }
}

