/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RitualBrazierBlock
extends TickableModBlock {
    public static VoxelShape shape = Stream.of(Block.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Stream.of(Block.box((double)2.0, (double)14.0, (double)2.0, (double)11.0, (double)16.0, (double)5.0), Block.box((double)7.0, (double)11.0, (double)1.0, (double)9.0, (double)15.0, (double)6.0), Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)5.0, (double)4.0), Block.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)11.0, (double)6.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Stream.of(Block.box((double)2.0, (double)14.0, (double)5.0, (double)5.0, (double)16.0, (double)14.0), Block.box((double)1.0, (double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)9.0), Block.box((double)0.0, (double)0.0, (double)7.0, (double)4.0, (double)5.0, (double)9.0), Block.box((double)4.0, (double)0.0, (double)7.0, (double)6.0, (double)11.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Stream.of(Block.box((double)5.0, (double)14.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)7.0, (double)11.0, (double)10.0, (double)9.0, (double)15.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)12.0, (double)9.0, (double)5.0, (double)16.0), Block.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)11.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Stream.of(Block.box((double)11.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)11.0), Block.box((double)10.0, (double)11.0, (double)7.0, (double)15.0, (double)15.0, (double)9.0), Block.box((double)12.0, (double)0.0, (double)7.0, (double)16.0, (double)5.0, (double)9.0), Block.box((double)10.0, (double)0.0, (double)7.0, (double)12.0, (double)11.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final Property<Boolean> LIT = BooleanProperty.create((String)"lit");

    public RitualBrazierBlock() {
        super(RitualBrazierBlock.defaultProperties().noOcclusion().pushReaction(PushReaction.BLOCK).lightLevel(b -> (Boolean)b.getValue(LIT) != false ? 15 : 0));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(LIT, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        RitualBrazierTile tile;
        block6: {
            block5: {
                BlockEntity blockEntity = worldIn.getBlockEntity(pos);
                if (!(blockEntity instanceof RitualBrazierTile)) break block5;
                tile = (RitualBrazierTile)blockEntity;
                if (handIn == InteractionHand.MAIN_HAND) break block6;
            }
            return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
        }
        ItemStack heldStack = player.getMainHandItem();
        if (heldStack.isEmpty() && tile.ritual != null && !tile.isRitualDone()) {
            tile.startRitual(player);
        }
        if (!heldStack.isEmpty()) {
            tile.tryBurnStack(heldStack);
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) instanceof RitualBrazierTile) {
            RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
            boolean wasOff = tile.isOff;
            tile.isOff = world.hasNeighborSignal(pos);
            if (wasOff != world.hasNeighborSignal(pos) && tile.ritual != null) {
                tile.ritual.onStatusChanged(tile.isOff);
            }
            if (world.hasNeighborSignal(pos) && tile.ritual != null && tile.ritual.canStart(null)) {
                tile.startRitual(null);
            }
            BlockUtil.safelyUpdateState(world, pos);
        }
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof RitualBrazierTile) {
            RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
            if (tile.ritual != null) {
                tile.ritual.onDestroy();
                if (!tile.ritual.isRunning() && !tile.ritual.isDone()) {
                    worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)RitualRegistry.getRitualItemMap().get(tile.ritual.getRegistryName()))));
                    for (ItemStack item : tile.ritual.getConsumedItems()) {
                        worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), item));
                    }
                }
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RitualBrazierTile(pos, state);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shape;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

