/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArchfruitPod
extends CocoaBlock
implements ILightable {
    public TagKey<Block> surviveTag;
    @Deprecated(since="4.12.0", forRemoval=true)
    public Supplier<Block> surviveBlock;
    protected static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.box((double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0), Block.box((double)9.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), Block.box((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)11.0, (double)12.0)};
    protected static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.box((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)11.0, (double)5.0), Block.box((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)7.0), Block.box((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)11.0, (double)9.0)};
    protected static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.box((double)6.0, (double)7.0, (double)11.0, (double)10.0, (double)11.0, (double)15.0), Block.box((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)11.0, (double)15.0)};
    protected static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.box((double)1.0, (double)7.0, (double)6.0, (double)5.0, (double)11.0, (double)10.0), Block.box((double)1.0, (double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0), Block.box((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)11.0, (double)12.0)};

    @Deprecated(since="4.12.0", forRemoval=true)
    public ArchfruitPod(Supplier<Block> surviveBlock) {
        this(BlockBehaviour.Properties.of().randomTicks().strength(0.2f, 3.0f).sound(SoundType.WOOD).noOcclusion().lightLevel(b -> (Integer)b.getValue(SconceBlock.LIGHT_LEVEL)).pushReaction(PushReaction.DESTROY).mapColor(MapColor.PLANT));
        this.surviveBlock = surviveBlock;
    }

    public ArchfruitPod(TagKey<Block> surviveBlocks) {
        this(BlockBehaviour.Properties.of().randomTicks().strength(0.2f, 3.0f).sound(SoundType.WOOD).noOcclusion().lightLevel(b -> (Integer)b.getValue(SconceBlock.LIGHT_LEVEL)).pushReaction(PushReaction.DESTROY).mapColor(MapColor.PLANT));
        this.surviveTag = surviveBlocks;
    }

    public ArchfruitPod(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos.relative((Direction)pState.getValue((Property)FACING)));
        if (this.surviveTag != null) {
            return blockstate.is(this.surviveTag);
        }
        if (this.surviveBlock != null) {
            return blockstate.getBlock() == this.surviveBlock.get();
        }
        return false;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int i = (Integer)pState.getValue((Property)AGE);
        switch ((Direction)pState.getValue((Property)FACING)) {
            case SOUTH: {
                return SOUTH_AABB[i];
            }
            case WEST: {
                return WEST_AABB[i];
            }
            case EAST: {
                return EAST_AABB[i];
            }
        }
        return NORTH_AABB[i];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, AGE, SconceBlock.LIGHT_LEVEL});
    }

    @Override
    public void onLight(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            BlockState state = world.getBlockState(blockHitResult.getBlockPos());
            world.setBlock(blockHitResult.getBlockPos(), (BlockState)state.setValue(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 8 - stats.getBuffCount(AugmentDampen.INSTANCE)), 8))), 3);
            world.sendBlockUpdated(blockHitResult.getBlockPos(), state, (BlockState)state.setValue(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 8 - stats.getBuffCount(AugmentDampen.INSTANCE)), 8))), 3);
        }
    }
}

