/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.google.common.collect.AbstractIterator;
import com.hollingsworth.arsnouveau.client.events.ClientEvents;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EmiMultiInputRecipe<T>
implements EmiRecipe {
    protected T recipe;
    protected ResourceLocation id;
    protected MultiProvider multiProvider;
    protected Vec2 point;
    protected Vec2 center;
    List<EmiIngredient> cachedInputs = null;

    public EmiMultiInputRecipe(ResourceLocation id, T recipe, MultiProvider multiProvider) {
        this.id = id;
        this.recipe = recipe;
        this.multiProvider = multiProvider;
        this.reset();
    }

    public T getRecipe() {
        return this.recipe;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public void reset() {
        int w = this.getDisplayWidth();
        int h = this.getDisplayHeight();
        this.center = new Vec2((float)((int)((double)w * 0.5) - 8), (float)((int)((double)h * 0.5) - 9));
        this.point = this.center.add(new Vec2(0.0f, -32.0f));
    }

    public int getDisplayWidth() {
        return 120;
    }

    public MultiProvider getMultiProvider() {
        return this.multiProvider;
    }

    public EmiIngredient getCenter() {
        return this.multiProvider.getEmiCenter();
    }

    public void addWidgets(WidgetHolder widgets) {
        this.reset();
        MultiProvider provider = this.multiProvider;
        List<Ingredient> inputs = provider.input;
        double angleBetweenEach = 360.0 / (double)inputs.size();
        EmiIngredient centerIngredient = this.getCenter();
        if (centerIngredient != null) {
            widgets.addSlot(centerIngredient, (int)this.center.x, (int)this.center.y);
        }
        for (EmiIngredient input : provider.getEmiInputs()) {
            widgets.addSlot(input, (int)this.point.x, (int)this.point.y);
            this.point = EmiMultiInputRecipe.rotatePointAbout(this.point, this.center, angleBetweenEach);
        }
        List<EmiStack> outputs = this.getOutputs();
        if (!outputs.isEmpty()) {
            widgets.addSlot((EmiIngredient)outputs.getFirst(), 100, 3).recipeContext((EmiRecipe)this);
        }
    }

    public final List<EmiIngredient> getInputs() {
        if (this.cachedInputs == null) {
            this.cachedInputs = this.generateInputs();
            ClientEvents.recipeChangeListeners.add(e -> {
                this.cachedInputs = null;
                return false;
            });
        }
        return this.cachedInputs;
    }

    protected List<EmiIngredient> generateInputs() {
        int size = this.multiProvider.input.size();
        if (this.multiProvider.hasCenter()) {
            ++size;
        }
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>(size);
        if (this.multiProvider.hasCenter()) {
            inputs.add(this.multiProvider.getEmiCenter());
        }
        for (Ingredient entry : this.multiProvider.input) {
            inputs.add(EmiIngredient.of((Ingredient)entry));
        }
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemStack)this.multiProvider.output));
    }

    public static Vec2 rotatePointAbout(Vec2 in, Vec2 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Vec2((float)newX, (float)newY);
    }

    public record MultiProvider(ItemStack output, List<Ingredient> input, @Nullable Ingredient optionalCenter) {
        public EmiStack getEmiOutput() {
            return EmiStack.of((ItemStack)this.output);
        }

        public boolean hasCenter() {
            return this.optionalCenter != null;
        }

        @Nullable
        public EmiIngredient getEmiCenter() {
            if (this.optionalCenter == null) {
                return null;
            }
            return EmiIngredient.of((Ingredient)this.optionalCenter);
        }

        public Iterable<EmiIngredient> getEmiInputs() {
            return new Iterable<EmiIngredient>(){

                @Override
                @NotNull
                public Iterator<EmiIngredient> iterator() {
                    return new AbstractIterator<EmiIngredient>(){
                        final Iterator<Ingredient> iterator;
                        {
                            this.iterator = input.iterator();
                        }

                        @Nullable
                        protected EmiIngredient computeNext() {
                            if (!this.iterator.hasNext()) {
                                return (EmiIngredient)this.endOfData();
                            }
                            return EmiIngredient.of((Ingredient)this.iterator.next());
                        }
                    };
                }
            };
        }
    }
}

