/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.recipe_viewer.jei;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.recipe_viewer.RecipeViewerHelper;
import moze_intel.projecte.integration.recipe_viewer.WorldTransmuteEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WorldTransmuteRecipeCategory
implements IRecipeCategory<WorldTransmuteEntry> {
    public static final RecipeType<WorldTransmuteEntry> RECIPE_TYPE = new RecipeType(PECore.rl("world_transmutation"), WorldTransmuteEntry.class);
    private final IDrawable icon;

    public WorldTransmuteRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)PEItems.PHILOSOPHERS_STONE.asStack());
    }

    @NotNull
    public RecipeType<WorldTransmuteEntry> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return PELang.WORLD_TRANSMUTE.translate();
    }

    public ResourceLocation getRegistryName(WorldTransmuteEntry recipe) {
        return recipe.syntheticId();
    }

    public int getWidth() {
        return 90;
    }

    public int getHeight() {
        return 26;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull WorldTransmuteEntry recipe, @NotNull IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(25, 5);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull WorldTransmuteEntry recipe, @NotNull IFocusGroup focuses) {
        this.addIngredient(builder, RecipeIngredientRole.INPUT, 5, recipe.input());
        this.addIngredient(builder, RecipeIngredientRole.OUTPUT, 51, recipe.output());
        if (recipe.altOutput() != null) {
            this.addIngredient(builder, RecipeIngredientRole.OUTPUT, 68, recipe.altOutput());
        }
    }

    private void addIngredient(IRecipeLayoutBuilder builder, RecipeIngredientRole role, int xPos, Either<ItemStack, FluidStack> ingredient) {
        IRecipeSlotBuilder slot = builder.addSlot(role, xPos, 5);
        ingredient.ifLeft(arg_0 -> ((IRecipeSlotBuilder)slot).addItemStack(arg_0));
        Optional right = ingredient.right();
        if (right.isPresent()) {
            ((IRecipeSlotBuilder)slot.addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)((FluidStack)right.get()))).setFluidRenderer(1000L, false, 16, 16);
        }
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull WorldTransmuteEntry recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 25.0 && mouseX < 49.0 && mouseY >= 5.0 && mouseY < 21.0) {
            tooltip.add((FormattedText)RecipeViewerHelper.getTransmuteDescription());
        }
    }

    @NotNull
    public Codec<WorldTransmuteEntry> getCodec(@NotNull ICodecHelper codecHelper, @NotNull IRecipeManager recipeManager) {
        return WorldTransmuteEntry.CODEC;
    }
}

