/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.recipe_viewer.jei;

import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.gameObjs.container.PhilosStoneContainer;
import moze_intel.projecte.gameObjs.gui.AbstractCollectorScreen;
import moze_intel.projecte.gameObjs.gui.GUIDMFurnace;
import moze_intel.projecte.gameObjs.gui.GUIRMFurnace;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.recipe_viewer.RecipeViewerHelper;
import moze_intel.projecte.integration.recipe_viewer.alias.ProjectEAliasMapping;
import moze_intel.projecte.integration.recipe_viewer.jei.CollectorRecipeCategory;
import moze_intel.projecte.integration.recipe_viewer.jei.JEIAliasHelper;
import moze_intel.projecte.integration.recipe_viewer.jei.WorldTransmuteRecipeCategory;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class PEJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = PECore.rl("main");
    private static final ISubtypeInterpreter<ItemStack> PROJECTE_INTERPRETER = new ISubtypeInterpreter<ItemStack>(){

        @Nullable
        public Object getSubtypeData(@NotNull ItemStack stack, @NotNull UidContext context) {
            if (context == UidContext.Ingredient) {
                Long stored;
                Object mode = null;
                Item item = stack.getItem();
                if (item instanceof IModeChanger) {
                    IModeChanger modeChanger = (IModeChanger)item;
                    mode = modeChanger.getMode(stack);
                }
                if ((stored = (Long)stack.get(PEDataComponentTypes.STORED_EMC)) != null && stored > 0L) {
                    return mode == null ? stored : List.of(mode, stored);
                }
                return mode;
            }
            return null;
        }

        @NotNull
        public String getLegacyStringSubtypeInfo(@NotNull ItemStack stack, @NotNull UidContext context) {
            if (context == UidContext.Ingredient) {
                Long stored;
                Object mode = null;
                Item item = stack.getItem();
                if (item instanceof IModeChanger) {
                    IModeChanger modeChanger = (IModeChanger)item;
                    mode = modeChanger.getMode(stack);
                }
                if ((stored = (Long)stack.get(PEDataComponentTypes.STORED_EMC)) != null && stored > 0L) {
                    return mode == null ? stored.toString() : String.valueOf(mode) + ";" + stored;
                }
                if (mode != null) {
                    return mode.toString();
                }
            }
            return "";
        }
    };

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    private static boolean shouldLoad() {
        return !ModList.get().isLoaded("emi");
    }

    public static void registerItemSubtypes(ISubtypeRegistration registry, Collection<? extends Holder<? extends ItemLike>> itemProviders) {
        for (Holder<? extends ItemLike> holder : itemProviders) {
            registry.registerSubtypeInterpreter(((ItemLike)holder.value()).asItem(), PROJECTE_INTERPRETER);
        }
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registry) {
        if (PEJeiPlugin.shouldLoad()) {
            PEJeiPlugin.registerItemSubtypes(registry, PEItems.ITEMS.getEntries());
            PEJeiPlugin.registerItemSubtypes(registry, PEBlocks.BLOCKS.getSecondaryEntries());
        }
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registry) {
        if (PEJeiPlugin.shouldLoad()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new WorldTransmuteRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
            registry.addRecipeCategories(new IRecipeCategory[]{new CollectorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        if (PEJeiPlugin.shouldLoad()) {
            registration.addRecipeTransferHandler(PhilosStoneContainer.class, MenuType.CRAFTING, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registry) {
        if (PEJeiPlugin.shouldLoad()) {
            registry.addRecipeCatalyst(PEItems.PHILOSOPHERS_STONE.asStack(), new RecipeType[]{RecipeTypes.CRAFTING, WorldTransmuteRecipeCategory.RECIPE_TYPE});
            registry.addRecipeCatalyst(new ItemStack(PEBlocks.COLLECTOR), new RecipeType[]{CollectorRecipeCategory.RECIPE_TYPE});
            registry.addRecipeCatalyst(new ItemStack(PEBlocks.COLLECTOR_MK2), new RecipeType[]{CollectorRecipeCategory.RECIPE_TYPE});
            registry.addRecipeCatalyst(new ItemStack(PEBlocks.COLLECTOR_MK3), new RecipeType[]{CollectorRecipeCategory.RECIPE_TYPE});
            registry.addRecipeCatalyst(new ItemStack(PEBlocks.DARK_MATTER_FURNACE), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
            registry.addRecipeCatalyst(new ItemStack(PEBlocks.RED_MATTER_FURNACE), new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
        }
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registry) {
        if (PEJeiPlugin.shouldLoad()) {
            registry.addRecipeClickArea(GUIDMFurnace.class, 73, 34, 25, 16, new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
            registry.addRecipeClickArea(GUIRMFurnace.class, 88, 35, 25, 17, new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
            registry.addRecipeClickArea(AbstractCollectorScreen.MK1.class, 138, 31, 10, 24, new RecipeType[]{CollectorRecipeCategory.RECIPE_TYPE});
            registry.addRecipeClickArea(AbstractCollectorScreen.MK2.class, 154, 31, 10, 24, new RecipeType[]{CollectorRecipeCategory.RECIPE_TYPE});
            registry.addRecipeClickArea(AbstractCollectorScreen.MK3.class, 172, 31, 10, 24, new RecipeType[]{CollectorRecipeCategory.RECIPE_TYPE});
        }
    }

    public void registerIngredientAliases(@NotNull IIngredientAliasRegistration registration) {
        new ProjectEAliasMapping().addAliases(new JEIAliasHelper(registration));
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        if (PEJeiPlugin.shouldLoad()) {
            registry.addRecipes(WorldTransmuteRecipeCategory.RECIPE_TYPE, List.copyOf(RecipeViewerHelper.getAllTransmutations()));
            registry.addRecipes(CollectorRecipeCategory.RECIPE_TYPE, RecipeViewerHelper.getFuelUpgrades());
        }
    }
}

