/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.recipe_viewer.emi;

import com.mojang.datafixers.util.Either;
import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.recipe_viewer.RecipeViewerHelper;
import moze_intel.projecte.integration.recipe_viewer.WorldTransmuteEntry;
import moze_intel.projecte.integration.recipe_viewer.emi.PEEmiCategory;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class WorldTransmuteEmiRecipe
implements EmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new PEEmiCategory("world_transmutation", PEItems.PHILOSOPHERS_STONE, PELang.WORLD_TRANSMUTE);
    private final ResourceLocation recipeId;
    private final List<EmiIngredient> input;
    private final List<EmiStack> outputs;

    public WorldTransmuteEmiRecipe(WorldTransmuteEntry recipe) {
        this.recipeId = recipe.syntheticId();
        this.input = List.of(WorldTransmuteEmiRecipe.asStack(recipe.input()));
        this.outputs = recipe.altOutput() == null ? List.of(WorldTransmuteEmiRecipe.asStack(recipe.output())) : List.of(WorldTransmuteEmiRecipe.asStack(recipe.output()), WorldTransmuteEmiRecipe.asStack(recipe.altOutput()));
    }

    private static EmiStack asStack(Either<ItemStack, FluidStack> ingredient) {
        return (EmiStack)ingredient.map(EmiStack::of, NeoForgeEmiStack::of);
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipeId;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 100;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        SlotWidget inputSlot = widgets.addSlot(this.input.getFirst(), 5, 5).drawBack(false);
        Bounds inputBounds = inputSlot.getBounds();
        TextureWidget arrow = (TextureWidget)widgets.addFillingArrow(3 + inputBounds.right(), inputBounds.y(), (int)(5L * TimeUtil.MILLISECONDS_PER_SECOND)).tooltip(List.of(ClientTooltipComponent.create((FormattedCharSequence)RecipeViewerHelper.getTransmuteDescription().getVisualOrderText())));
        int xPos = arrow.getBounds().right() + 3;
        for (EmiStack emiStack : this.outputs) {
            SlotWidget slot = widgets.addSlot((EmiIngredient)emiStack, xPos, inputBounds.y()).drawBack(false).recipeContext((EmiRecipe)this);
            xPos += slot.getBounds().width() + 1;
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    @Nullable
    public RecipeHolder<?> getBackingRecipe() {
        return null;
    }
}

