/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepairTalisman
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem,
ICapabilityAware {
    private static final BiPredicate<ItemStack, Void> CAN_REPAIR_ITEM = (stack, ignored) -> !stack.isEmpty() && stack.getCapability(PECapabilities.MODE_CHANGER_ITEM_CAPABILITY) == null && ItemHelper.isRepairableDamagedItem(stack);
    private static final BiPredicate<ItemStack, Player> CAN_REPAIR_PLAYER_ITEM = (stack, player) -> CAN_REPAIR_ITEM.test((ItemStack)stack, (Void)null) && (stack != player.getMainHandItem() || !player.swinging);

    public RepairTalisman(Item.Properties props) {
        super(props.component(PEDataComponentTypes.COOLDOWN, (Object)0));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        Player player;
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (!level.isClientSide && entity instanceof Player && PlayerHelper.checkCooldown(player = (Player)entity, this, ProjectEConfig.server.cooldown.player.repair)) {
            RepairTalisman.repairAllItems(player);
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.cooldown.pedestal.repair.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                level.getEntitiesOfClass(Player.class, ((IDMPedestal)pedestal).getEffectBounds()).forEach(RepairTalisman::repairAllItems);
                ((IDMPedestal)pedestal).setActivityCooldown(level, pos, ProjectEConfig.server.cooldown.pedestal.repair.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown(level, pos);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.repair.get() != -1) {
            list.add((Component)PELang.PEDESTAL_REPAIR_TALISMAN_1.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_REPAIR_TALISMAN_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.repair.get(), tickRate)));
        }
        return list;
    }

    @Override
    public boolean updateInAlchChest(@NotNull Level level, @NotNull BlockPos pos, @NotNull ItemStack stack) {
        IItemHandler inv;
        if (!level.isClientSide && (inv = (IItemHandler)WorldHelper.getCapability(level, Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
            return this.updateInHandler(inv, stack);
        }
        return false;
    }

    @Override
    public boolean updateInAlchBag(@NotNull IItemHandler inv, @NotNull Player player, @NotNull ItemStack stack) {
        return !player.level().isClientSide && this.updateInHandler(inv, stack);
    }

    private boolean updateInHandler(@NotNull IItemHandler inv, @NotNull ItemStack stack) {
        byte coolDown = (Byte)stack.getOrDefault(PEDataComponentTypes.COOLDOWN, (Object)0);
        if (coolDown > 0) {
            stack.set(PEDataComponentTypes.COOLDOWN, (Object)((byte)(coolDown - 1)));
            return true;
        }
        if (RepairTalisman.repairAllItems(inv, null, CAN_REPAIR_ITEM)) {
            stack.set(PEDataComponentTypes.COOLDOWN, (Object)19);
            return true;
        }
        return false;
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }

    private static void repairAllItems(Player player) {
        RepairTalisman.repairAllItems((IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY), player, CAN_REPAIR_PLAYER_ITEM);
        RepairTalisman.repairAllItems((IItemHandler)player.getCapability(IntegrationHelper.CURIO_ITEM_HANDLER), player, CAN_REPAIR_PLAYER_ITEM);
    }

    private static <DATA> boolean repairAllItems(@Nullable IItemHandler inv, DATA data, BiPredicate<ItemStack, DATA> canRepairStack) {
        if (inv == null) {
            return false;
        }
        boolean hasAction = false;
        int slots = inv.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (!canRepairStack.test(invStack, data)) continue;
            invStack.setDamageValue(invStack.getDamageValue() - 1);
            if (hasAction) continue;
            hasAction = true;
        }
        return hasAction;
    }
}

