/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.events.TickEvents;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.gameObjs.items.armor.PEArmor;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber(modid="projecte")
public class PlayerEvents {
    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            IAlchBagProvider bagProvider;
            ServerPlayer player2 = (ServerPlayer)player;
            IKnowledgeProvider knowledge = (IKnowledgeProvider)player2.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
            if (knowledge != null) {
                knowledge.sync(player2);
            }
            if ((bagProvider = (IAlchBagProvider)player2.getCapability(PECapabilities.ALCH_BAG_CAPABILITY)) != null) {
                bagProvider.syncAllBags(player2);
            }
        }
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            IAlchBagProvider bagProvider;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            IKnowledgeProvider knowledge = (IKnowledgeProvider)serverPlayer.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
            if (knowledge != null) {
                knowledge.sync(serverPlayer);
            }
            if ((bagProvider = (IAlchBagProvider)serverPlayer.getCapability(PECapabilities.ALCH_BAG_CAPABILITY)) != null) {
                bagProvider.syncAllBags(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        IAlchBagProvider alchBagProvider;
        ServerPlayer player = (ServerPlayer)event.getEntity();
        IKnowledgeProvider knowledge = (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge != null) {
            knowledge.sync(player);
            PlayerHelper.updateScore(player, PlayerHelper.SCOREBOARD_EMC, knowledge.getEmc());
        }
        if ((alchBagProvider = (IAlchBagProvider)player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY)) != null) {
            alchBagProvider.syncAllBags(player);
        }
        PECore.debugLog("Sent knowledge and bag data to {}", player.getName());
    }

    @SubscribeEvent
    public static void onConstruct(EntityEvent.EntityConstructing evt) {
        if (EffectiveSide.get().isServer() && evt.getEntity() instanceof Player && !(evt.getEntity() instanceof FakePlayer)) {
            TransmutationOffline.clear(evt.getEntity().getUUID());
            PECore.debugLog("Clearing offline data cache in preparation to load online data", new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onHighAlchemistJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        MinecraftServer server;
        if (PECore.uuids.contains(evt.getEntity().getUUID().toString()) && (server = evt.getEntity().getServer()) != null) {
            MutableComponent joinMessage = PELang.HIGH_ALCHEMIST.translateColored(ChatFormatting.BLUE, ChatFormatting.GOLD, evt.getEntity().getDisplayName());
            server.getPlayerList().broadcastSystemMessage((Component)joinMessage, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void pickupItem(ItemEntityPickupEvent.Pre event) {
        IAlchBagProvider bagProvider;
        ItemEntity itemEntity = event.getItemEntity();
        Player player = event.getPlayer();
        if (itemEntity.level().isClientSide || itemEntity.hasPickUpDelay() || itemEntity.getTarget() != null && !player.getUUID().equals(itemEntity.getTarget())) {
            return;
        }
        ItemStack bag = AlchemicalBag.getFirstBagWithSuctionItem(player, (NonNullList<ItemStack>)player.getInventory().items);
        if (!bag.isEmpty() && (bagProvider = (IAlchBagProvider)player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY)) != null) {
            ItemStack stack = itemEntity.getItem();
            IItemHandler handler = bagProvider.getBag(((AlchemicalBag)bag.getItem()).color);
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            int pickedUpCount = stack.getCount() - remainder.getCount();
            if (pickedUpCount > 0) {
                event.setCanPickup(TriState.FALSE);
                player.take((Entity)itemEntity, pickedUpCount);
                if (remainder.isEmpty()) {
                    itemEntity.discard();
                    stack.setCount(pickedUpCount);
                }
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)stack.getItem()), pickedUpCount);
                player.onItemPickup(itemEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onInvulnerabilityChecked(EntityInvulnerabilityCheckEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (evt.getSource().is(DamageTypeTags.IS_FIRE) && TickEvents.shouldPlayerResistFire((Player)player)) {
                evt.setInvulnerable(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamaged(LivingIncomingDamageEvent event) {
        DamageContainer damageContainer = event.getContainer();
        if (damageContainer.getNewDamage() > 0.0f) {
            PEArmor.ReductionInfo reductionInfo = PEArmor.ReductionInfo.ZERO;
            for (ItemStack armorStack : event.getEntity().getArmorSlots()) {
                Item item = armorStack.getItem();
                if (!(item instanceof PEArmor)) continue;
                PEArmor armorItem = (PEArmor)item;
                reductionInfo = reductionInfo.add(armorItem.getReductionInfo(damageContainer.getSource()));
            }
            if (reductionInfo.percentReduced() >= 1.0f) {
                event.setCanceled(true);
            } else if (reductionInfo.maxDamagedAbsorbed() > 0.0f && reductionInfo.percentReduced() > 0.0f) {
                PEArmor.ReductionInfo info = reductionInfo;
                damageContainer.addModifier(DamageContainer.Reduction.ARMOR, (container, reduction) -> {
                    float damageAbsorbed = container.getNewDamage() * info.percentReduced();
                    return reduction + Math.min(damageAbsorbed, info.maxDamagedAbsorbed());
                });
            }
        }
    }
}

