/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.arithmetic.IValueArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import org.jetbrains.annotations.NotNull;

public abstract class MappingCollector<T, V extends Comparable<V>, A extends IValueArithmetic<V>>
extends AbstractMappingCollector<T, V, A> {
    private static final boolean DEBUG_GRAPHMAPPER = false;
    private final Function<T, Set<Conversion>> CREATE_CONVERSIONS = t -> new LinkedHashSet();
    protected final A arithmetic;
    protected final Map<@NotNull T, @NotNull Conversion> overwriteConversion = new HashMap<T, Conversion>();
    protected final Map<@NotNull T, @NotNull Set<Conversion>> conversionsFor = new HashMap<T, Set<Conversion>>();
    protected final Map<@NotNull T, @NotNull Set<Conversion>> usedIn = new HashMap<T, Set<Conversion>>();
    protected final Map<@NotNull T, @NotNull V> fixValueBeforeInherit = new HashMap<T, V>();
    protected final Map<@NotNull T, @NotNull V> fixValueAfterInherit = new HashMap<T, V>();

    protected MappingCollector(A arithmetic) {
        super(arithmetic);
        this.arithmetic = arithmetic;
    }

    protected static boolean isDebugGraphmapper() {
        return false;
    }

    protected static void debugFormat(String format, Object ... args) {
        if (MappingCollector.isDebugGraphmapper()) {
            PECore.debugLog(format, args);
        }
    }

    protected static void debugPrintln(String s) {
        MappingCollector.debugFormat(s, new Object[0]);
    }

    private Set<Conversion> getConversionsFor(@NotNull T something) {
        return this.conversionsFor.computeIfAbsent(something, this.CREATE_CONVERSIONS);
    }

    protected void removeUseFor(@NotNull T something, @NotNull Conversion conversion) {
        Set<Conversion> conversions = this.usedIn.get(something);
        if (conversions != null) {
            conversions.remove(conversion);
        }
    }

    protected Set<Conversion> getUsesFor(@NotNull T something) {
        return this.usedIn.computeIfAbsent(something, this.CREATE_CONVERSIONS);
    }

    private void addConversionToIngredientUsages(Conversion conversion) {
        for (Object ingredient : conversion.ingredientsWithAmount.keySet()) {
            this.getUsesFor(ingredient).add(conversion);
        }
    }

    @Override
    public void addConversion(int outnumber, T output, Object2IntMap<T> ingredientsWithAmount, A arithmeticForConversion) {
        if (output == null || ingredientsWithAmount.containsKey(null)) {
            PECore.debugLog("Ignoring Recipe because of invalid ingredient or output: {} -> {}x{}", ingredientsWithAmount, outnumber, output);
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(this, output, outnumber, ingredientsWithAmount, arithmeticForConversion, this.arithmetic.getZero());
        if (this.getConversionsFor(output).add(conversion)) {
            this.addConversionToIngredientUsages(conversion);
        }
    }

    @Override
    public void setValueBefore(T something, V value) {
        if (something == null || value == null) {
            return;
        }
        Comparable valueBeforeInherit = (Comparable)this.fixValueBeforeInherit.get(something);
        if (valueBeforeInherit != null) {
            PECore.debugLog("Overwriting fixValueBeforeInherit for {} from: {} to {}", something, valueBeforeInherit, value);
        }
        this.fixValueBeforeInherit.put(something, value);
        this.fixValueAfterInherit.remove(something);
    }

    @Override
    public void setValueAfter(T something, V value) {
        if (something == null || value == null) {
            return;
        }
        Comparable valueAfterInherit = (Comparable)this.fixValueAfterInherit.get(something);
        if (valueAfterInherit != null) {
            PECore.debugLog("Overwriting fixValueAfterInherit for {} from: {} to {}", something, valueAfterInherit, value);
        }
        this.fixValueAfterInherit.put(something, value);
    }

    @Override
    public void setValueFromConversion(int outnumber, T something, Object2IntMap<T> ingredientsWithAmount) {
        if (something == null || ingredientsWithAmount.containsKey(null)) {
            PECore.debugLog("Ignoring setValueFromConversion because of invalid ingredient or output: {} -> {}x{}", ingredientsWithAmount, outnumber, something);
            return;
        }
        if (outnumber <= 0) {
            throw new IllegalArgumentException("outnumber has to be > 0!");
        }
        Conversion conversion = new Conversion(this, something, outnumber, ingredientsWithAmount, this.arithmetic);
        Conversion oldConversion = this.overwriteConversion.get(something);
        if (oldConversion != null) {
            PECore.debugLog("Overwriting setValueFromConversion {} with {}", oldConversion, conversion);
            for (Object ingredient : oldConversion.ingredientsWithAmount.keySet()) {
                this.removeUseFor(ingredient, oldConversion);
            }
        }
        this.addConversionToIngredientUsages(conversion);
        this.overwriteConversion.put(something, conversion);
    }

    protected class Conversion {
        public final T output;
        public final int outnumber;
        public final V value;
        public final Object2IntMap<T> ingredientsWithAmount;
        public final A arithmeticForConversion;
        private final int hash;

        Conversion(T output, int outnumber, Object2IntMap<T> ingredientsWithAmount, A arithmeticForConversion) {
            this(this$0, output, outnumber, ingredientsWithAmount, (IValueArithmetic)arithmeticForConversion, (Comparable)this$0.arithmetic.getZero());
        }

        /*
         * WARNING - Possible parameter corruption
         */
        Conversion(T output, int outnumber, Object2IntMap<T> ingredientsWithAmount, A arithmeticForConversion, V value) {
            this.output = output;
            this.outnumber = outnumber;
            if (ingredientsWithAmount == null || ingredientsWithAmount.isEmpty()) {
                this.ingredientsWithAmount = Object2IntMaps.emptyMap();
            } else {
                Object2IntOpenHashMap filteredMap = new Object2IntOpenHashMap(ingredientsWithAmount.size());
                ObjectIterator iterator = Object2IntMaps.fastIterator(ingredientsWithAmount);
                while (iterator.hasNext()) {
                    Object2IntMap.Entry ingredient = (Object2IntMap.Entry)iterator.next();
                    int amount = ingredient.getIntValue();
                    if (amount == 0) continue;
                    filteredMap.put(ingredient.getKey(), amount);
                }
                this.ingredientsWithAmount = filteredMap;
            }
            this.arithmeticForConversion = arithmeticForConversion;
            this.value = value;
            this.hash = Objects.hash(this.output, this.value, this.ingredientsWithAmount);
        }

        public String toString() {
            return String.valueOf(this.value) + " + " + this.ingredientsToString() + " => " + this.outnumber + "*" + String.valueOf(this.output);
        }

        private String ingredientsToString() {
            if (this.ingredientsWithAmount.isEmpty()) {
                return "nothing";
            }
            StringBuilder ingredients = new StringBuilder();
            boolean addSeparator = false;
            ObjectIterator iterator = Object2IntMaps.fastIterator(this.ingredientsWithAmount);
            while (iterator.hasNext()) {
                Object2IntMap.Entry ingredient = (Object2IntMap.Entry)iterator.next();
                if (addSeparator) {
                    ingredients.append(" + ");
                } else {
                    addSeparator = true;
                }
                ingredients.append(ingredient.getIntValue()).append('*').append(ingredient.getKey());
            }
            return ingredients.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Conversion)) return false;
            Conversion other = (Conversion)o;
            if (!Objects.equals(this.output, other.output)) return false;
            if (!Objects.equals(this.value, other.value)) return false;
            if (!Objects.equals(this.ingredientsWithAmount, other.ingredientsWithAmount)) return false;
            return true;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

