/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import moze_intel.projecte.api.data.WorldTransmutationBuilder;
import moze_intel.projecte.api.world_transmutation.WorldTransmutationFile;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class WorldTransmutationProvider
implements DataProvider {
    private final Map<ResourceLocation, ConditionalBuilder> worldTransmutations = new LinkedHashMap<ResourceLocation, ConditionalBuilder>();
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final PackOutput.PathProvider outputProvider;
    private final String modid;
    private final Set<BlockState> seenBlockStates = new ReferenceOpenHashSet();
    private final Set<Block> seenBlocks = new ReferenceOpenHashSet();

    protected WorldTransmutationProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid) {
        this.outputProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "pe_world_transmutations");
        this.lookupProvider = lookupProvider;
        this.modid = modid;
    }

    public final String getName() {
        return "World Transmutations: " + this.modid;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return ((CompletableFuture)this.lookupProvider.thenApply(registries -> {
            this.worldTransmutations.clear();
            this.addWorldTransmutations((HolderLookup.Provider)registries);
            return registries;
        })).thenCompose(registries -> CompletableFuture.allOf((CompletableFuture[])this.worldTransmutations.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, WorldTransmutationFile.CONDITIONAL_CODEC, ((ConditionalBuilder)entry.getValue()).build(), (Path)this.outputProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new)));
    }

    protected abstract void addWorldTransmutations(HolderLookup.Provider var1);

    protected WorldTransmutationBuilder createTransmutationBuilder(ResourceLocation id, ICondition ... conditions) {
        Objects.requireNonNull(id, "World Transmutation Builder ID cannot be null.");
        if (this.worldTransmutations.containsKey(id)) {
            throw new RuntimeException("World transmutation file '" + String.valueOf(id) + "' has already been registered.");
        }
        WorldTransmutationBuilder builder = new WorldTransmutationBuilder(this.seenBlocks, this.seenBlockStates);
        this.worldTransmutations.put(id, new ConditionalBuilder(builder, conditions));
        return builder;
    }

    private record ConditionalBuilder(WorldTransmutationBuilder builder, ICondition[] conditions) {
        public Optional<WithConditions<WorldTransmutationFile>> build() {
            return Optional.of(new WithConditions((Object)this.builder.build(), this.conditions));
        }
    }
}

