/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.capabilities;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.math.BigInteger;
import java.util.Set;
import java.util.function.IntFunction;
import moze_intel.projecte.api.ItemInfo;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public interface IKnowledgeProvider {
    public boolean hasFullKnowledge();

    public void setFullKnowledge(boolean var1);

    public void clearKnowledge();

    default public boolean hasKnowledge(@NotNull ItemStack stack) {
        return !stack.isEmpty() && this.hasKnowledge(ItemInfo.fromStack(stack));
    }

    public boolean hasKnowledge(@NotNull ItemInfo var1);

    default public boolean addKnowledge(@NotNull ItemStack stack) {
        return !stack.isEmpty() && this.addKnowledge(ItemInfo.fromStack(stack));
    }

    public boolean addKnowledge(@NotNull ItemInfo var1);

    default public boolean removeKnowledge(@NotNull ItemStack stack) {
        return !stack.isEmpty() && this.removeKnowledge(ItemInfo.fromStack(stack));
    }

    public boolean removeKnowledge(@NotNull ItemInfo var1);

    @NotNull
    public Set<ItemInfo> getKnowledge();

    @NotNull
    public IItemHandler getInputAndLocks();

    public BigInteger getEmc();

    public void setEmc(BigInteger var1);

    public void sync(@NotNull ServerPlayer var1);

    public void syncEmc(@NotNull ServerPlayer var1);

    public void syncKnowledgeChange(@NotNull ServerPlayer var1, ItemInfo var2, boolean var3);

    public void syncInputAndLocks(@NotNull ServerPlayer var1, IntList var2, TargetUpdateType var3);

    public void receiveInputsAndLocks(Int2ObjectMap<ItemStack> var1);

    public static enum TargetUpdateType {
        NONE,
        IF_NEEDED,
        ALL;

        public static final IntFunction<TargetUpdateType> BY_ID;
        public static final StreamCodec<ByteBuf, TargetUpdateType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])TargetUpdateType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

