/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.bundle;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.TitaniumFluidUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class TankInteractionBundle<T extends BasicTile>
implements IComponentBundle,
INBTSerializable<CompoundTag> {
    private final Supplier<Optional<IFluidHandler>> fluidHandler;
    private int posX;
    private int posY;
    private InventoryComponent<T> input;
    private InventoryComponent<T> output;
    private ProgressBarComponent<T> bar;

    public TankInteractionBundle(Supplier<Optional<IFluidHandler>> fluidHandler, int posX, int posY, T componentHarness, int maxProgress) {
        this.fluidHandler = fluidHandler;
        this.posX = posX;
        this.posY = posY;
        this.input = new InventoryComponent("tank_input", posX + 5, posY + 7, 1).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.BUCKET)).setOutputFilter((stack, integer) -> false).setSlotToColorRender(0, DyeColor.BLUE).setInputFilter((stack, integer) -> stack.getCapability(Capabilities.FluidHandler.ITEM) != null).setComponentHarness(componentHarness);
        this.output = new InventoryComponent("tank_output", posX + 5, posY + 60, 1).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.BUCKET)).setInputFilter((stack, integer) -> false).setSlotToColorRender(0, DyeColor.ORANGE).setComponentHarness(componentHarness);
        this.bar = new ProgressBarComponent(posX + 5, posY + 30, maxProgress).setBarDirection(ProgressBarComponent.BarDirection.ARROW_DOWN).setCanReset(t -> true).setCanIncrease(t -> !this.input.getStackInSlot(0).isEmpty() && this.input.getStackInSlot(0).getCapability(Capabilities.FluidHandler.ITEM) != null && !this.getOutputStack(false).isEmpty() && (this.output.getStackInSlot(0).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)this.getOutputStack(false), (ItemStack)this.input.getStackInSlot(0)))).setOnFinishWork(() -> {
            ItemStack result = this.getOutputStack(false);
            if (ItemHandlerHelper.insertItem(this.output, (ItemStack)result, (boolean)true).isEmpty()) {
                result = this.getOutputStack(true);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)result, (boolean)false);
                this.input.getStackInSlot(0).shrink(1);
                componentHarness.setChanged();
            }
        }).setComponentHarness((BasicTile)componentHarness);
    }

    @Override
    public void accept(IComponentHandler ... handler) {
        for (IComponentHandler iComponentHandler : handler) {
            iComponentHandler.add(this.input, this.output, this.bar);
        }
    }

    public ItemStack getOutputStack(boolean execute) {
        if (!this.fluidHandler.get().isPresent()) {
            return ItemStack.EMPTY;
        }
        IFluidHandler iFluidHandler = this.fluidHandler.get().get();
        ItemStack stack = this.input.getStackInSlot(0).copy();
        stack.setCount(1);
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)iFluidHandler, (int)Integer.MAX_VALUE, null, (boolean)execute);
        if (result.isSuccess()) {
            return result.getResult();
        }
        result = TitaniumFluidUtil.tryEmptyContainer(stack, iFluidHandler, Integer.MAX_VALUE, execute);
        if (result.isSuccess()) {
            return result.getResult();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Collections.singletonList(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, this.posX, this.posY, true));
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Collections.emptyList();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("Input", (Tag)this.input.serializeNBT(provider));
        compoundNBT.put("Output", (Tag)this.output.serializeNBT(provider));
        compoundNBT.put("Bar", (Tag)this.bar.serializeNBT(provider));
        return compoundNBT;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.input.deserializeNBT(provider, nbt.getCompound("Input"));
        this.output.deserializeNBT(provider, nbt.getCompound("Output"));
        this.bar.deserializeNBT(provider, nbt.getCompound("Bar"));
    }
}

