/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.CreateDecoMod;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class Doors {
    public static final BlockSetType OPEN_METAL_DOOR = new BlockSetType("metal", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.METAL, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.METAL_PRESSURE_PLATE_CLICK_OFF, SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON);

    public static NonNullBiConsumer<DataGenContext<Block, DoorBlock>, RegistrateRecipeProvider> recipe(Supplier<Item> ingot) {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)3).pattern("mm").pattern("mm").pattern("mm").define(Character.valueOf('m'), (ItemLike)ingot.get()).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()})).save((RecipeOutput)prov);
    }

    public static BlockBuilder<DoorBlock, ?> build(CreateRegistrate reg, String metal, boolean locked) {
        String regName = (locked ? "locked_" : "") + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_door";
        return (BlockBuilder)reg.block(regName, p -> new DoorBlock(locked ? BlockSetType.GOLD : OPEN_METAL_DOOR, p)).initialProperties(() -> Blocks.IRON_DOOR).properties(props -> props.noOcclusion().strength(5.0f, 5.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK)).blockstate((ctx, prov) -> BlockStateGenerator.door(reg, metal, locked, (DataGenContext<Block, DoorBlock>)ctx, prov)).addLayer(() -> RenderType::cutoutMipped).loot((table, block) -> {
            LootTable.Builder builder = LootTable.lootTable();
            LootPool.Builder pool = LootPool.lootPool();
            pool.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)));
            table.add((Block)block, builder.withPool(pool));
        }).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.DOORS}).item().tag(new TagKey[]{ItemTags.DOORS}).model((ctx, prov) -> BlockStateGenerator.doorItem(reg, metal, ctx, prov)).properties(props -> metal.contains("Netherite") ? props.fireResistant() : props).build();
    }

    public static NonNullBiConsumer<DataGenContext<Block, DoorBlock>, RegistrateRecipeProvider> lockedRecipe(Supplier<Item> originalDoor) {
        return (ctx, prov) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).requires((ItemLike)Items.REDSTONE_TORCH, 1).requires((ItemLike)originalDoor.get()).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)originalDoor.get()})).save((RecipeOutput)prov);
    }

    public static BlockBuilder<TrapDoorBlock, ?> buildTrapdoor(CreateRegistrate reg, String metal) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_trapdoor";
        String path = "block/palettes/doors/" + regName;
        ResourceLocation texture = CreateDecoMod.id(path);
        return (BlockBuilder)reg.block(regName, p -> new TrapDoorBlock(OPEN_METAL_DOOR, p)).properties(props -> props.noOcclusion().strength(5.0f, 5.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK)).blockstate((ctx, prov) -> prov.trapdoorBlock((TrapDoorBlock)ctx.get(), texture, true)).lang(metal + " Trapdoor").tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.TRAPDOORS}).addLayer(() -> RenderType::cutoutMipped).item().tag(new TagKey[]{ItemTags.TRAPDOORS}).model((ctx, prov) -> BlockStateGenerator.trapdoorItem(reg, metal, ctx, prov)).build();
    }

    public static NonNullBiConsumer<DataGenContext<Block, TrapDoorBlock>, RegistrateRecipeProvider> trapdoorRecipe(Supplier<Item> ingot) {
        return (ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("mm").pattern("mm").define(Character.valueOf('m'), (ItemLike)ingot.get()).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()})).save((RecipeOutput)prov);
    }
}

