/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.blockentity;

import com.klikli_dev.occultism.client.model.tile.DimensionalMatrixModel;
import com.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.util.Color;

public class StorageControllerGeoRenderer
extends GeoBlockRenderer<StorageControllerBlockEntity> {
    private final GeoModel<StorageControllerBlockEntity> modelProvider;

    public StorageControllerGeoRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        this(rendererDispatcherIn, new DimensionalMatrixModel());
    }

    public StorageControllerGeoRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn, GeoModel<StorageControllerBlockEntity> modelProvider) {
        super(modelProvider);
        this.modelProvider = modelProvider;
    }

    public void actuallyRender(PoseStack poseStack, StorageControllerBlockEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer bufferIn, boolean isReRender, float partialTicks, int packedLightIn, int packedOverlay, int colour) {
        poseStack.pushPose();
        poseStack.translate(0.0, 1.25, 0.0);
        long systemTime = System.currentTimeMillis();
        float angle = systemTime / 16L % 360L;
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        if (!isReRender) {
            AnimationState animationState = new AnimationState((GeoAnimatable)animatable, 0.0f, 0.0f, partialTicks, false);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, (Object)animatable.getTick(animatable));
            animationState.setData(DataTickets.BLOCK_ENTITY, (Object)animatable);
            this.model.addAdditionalStateData((GeoAnimatable)animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.model.handleAnimations((GeoAnimatable)animatable, instanceId, animationState, partialTicks);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation((GeoAnimatable)animatable));
        for (GeoBone group : model.topLevelBones()) {
            this.renderRecursively(poseStack, animatable, group, renderType, bufferSource, bufferIn, isReRender, partialTicks, packedLightIn, packedOverlay, colour);
        }
        poseStack.popPose();
    }

    public RenderType getRenderType(StorageControllerBlockEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucentCull((ResourceLocation)this.modelProvider.getTextureResource((GeoAnimatable)animatable));
    }

    public Color getRenderColor(StorageControllerBlockEntity animatable, float partialTick, int packedLight) {
        long systemTime = System.currentTimeMillis();
        double systemTimeRadSin8 = Math.sin(Math.toRadians((float)systemTime / 8.0f));
        long colorScale = 100L - Math.abs(systemTime / 16L / 2L % 160L - 80L);
        float saturation = (float)systemTimeRadSin8 * 0.5f + 0.5f;
        return Color.ofHSB((float)(0.01f * (float)colorScale), (float)saturation, (float)(0.01f * (float)colorScale));
    }
}

